package com.tydic.bcm.personal.dao;


import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmApplyCommodityConfPO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmApplyOrderSelTimeLimitConfMapper
 * 说明 选定时限配置Mapper
 * 时间 2023/7/28 10:00
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmApplyCommodityConfMapper {

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmApplyCommodityConfPO getModel(BcmApplyCommodityConfPO po);

    /**
     * 根据id修改数据
     * @param po
     */
    void updateById(BcmApplyCommodityConfPO po);

    /**
     * 根据条件分页查询列表数据
     * @param po 参数对象
     * @param page  分页参数
     * @return List<BcmApplyOrderSelTimeLimitConfPO> 结果对象
     */
    List<BcmApplyCommodityConfPO> getPageList(BcmApplyCommodityConfPO po, Page<BcmApplyCommodityConfPO> page);

    /**
     * 批量插入数据
     * @param list 参数列表
     * @return int 影响数量
     */
    int insertBatch(List<BcmApplyCommodityConfPO> list);

}
