package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 流程任务表;(bcm_flow_task)表数据库访问层
 *
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmFlowTaskMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BcmFlowTaskPO queryById(Long id);

    /**
     * 根据taskId查询
     *
     * @param taskId
     * @return
     */
    BcmFlowTaskPO queryByTaskId(String taskId);


    /**
     * 根据流程实例id
     *
     * @param instanceId
     * @return
     */
    List<BcmFlowTaskPO> queryByFlowInstanceId(String instanceId);

    /**
     * 新增数据
     *
     * @param bcmFlowTask 实例对象
     * @return 影响行数
     */
    int insert(BcmFlowTaskPO bcmFlowTask);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmFlowTask> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmFlowTaskPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmFlowTask> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmFlowTaskPO> entities);

    /**
     * 更新数据
     *
     * @param bcmFlowTask 实例对象
     * @return 影响行数
     */
    int update(BcmFlowTaskPO bcmFlowTask);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
}