package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmQuerySuggestedManagementInfoPO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmSuggestedManagementInfoMapper
 * 说明 我的建议Mapper
 * 时间 2023/7/24 10:25
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmSuggestedManagementInfoMapper {

    /**
     * 我的建议列表（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmSuggestedManagementInfoPO> getListPage(BcmQuerySuggestedManagementInfoPO po, Page<BcmSuggestedManagementInfoPO> page);

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmSuggestedManagementInfoPO getModelBy(BcmSuggestedManagementInfoPO po);

    /**
     * 插入单条数据
     * @param bcmSuggestedManagementInfoPO 参数对象
     * @return int 影响数量
     */
    int insert(BcmSuggestedManagementInfoPO bcmSuggestedManagementInfoPO);

    /**
     * 根据条件更新建议信息
     * @param set
     * @param where
     */
    void updateBy(@Param("set")BcmSuggestedManagementInfoPO set, @Param("where") BcmSuggestedManagementInfoPO where);
}
