/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmAddBatchApplyCommodityOrderSupplierReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmAddBatchReplyCommodityReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddReplyCommodityBO;
import com.tydic.bcm.personal.commodity.bo.BcmaddBatchReplyCommodityRspBO;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyPO;
import com.tydic.bcm.personal.po.BcmQueryFilePO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmAddBatchApplyCommodityOrderSupplierReplyService"})
public class BcmAddBatchApplyCommodityOrderSupplierReplyServiceImpl
implements BcmAddBatchApplyCommodityOrderSupplierReplyService {
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;
    @Autowired
    private BcmFileMapper bcmFileMapper;
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @PostMapping(value={"addBatchReplyCommodity"})
    public BcmaddBatchReplyCommodityRspBO addBatchReplyCommodity(@RequestBody BcmAddBatchReplyCommodityReqBO reqBO) {
        this.verifyParam(reqBO);
        this.check(reqBO);
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = this.getApplyCommodityOrderSupplierReply(reqBO);
        if (bcmApplyCommodityOrderSupplierReplyPO == null) {
            if (!CollectionUtils.isEmpty((Collection)reqBO.getReplyCommodityOrderItemList())) {
                long replyId = this.addApplyCommodityOrderSupplierReply(reqBO);
                this.addApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            }
        } else {
            long replyId = bcmApplyCommodityOrderSupplierReplyPO.getReplyId();
            this.updateFile(replyId);
            this.updateApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            if (!CollectionUtils.isEmpty((Collection)reqBO.getReplyCommodityOrderItemList())) {
                this.addApplyCommodityOrderSupplierReplyItem(reqBO, replyId);
            } else {
                this.updateApplyCommodityOrderSupplierReply(reqBO, replyId);
            }
        }
        return BcmRuUtil.success(BcmaddBatchReplyCommodityRspBO.class);
    }

    private void check(BcmAddBatchReplyCommodityReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = this.bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderPO == null) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u4e0a\u67b6\u7533\u8bf7\u5355");
        }
        if (!BcmPersonalApplyOrderStatusEnum.IN_REPLY.getStatus().equals(bcmApplyCommodityOrderPO.getApplyOrderStatus())) {
            throw new ZTBusinessException("\u4e0a\u67b6\u7533\u8bf7\u5355\u72b6\u6001\u4e0d\u662f\u5e94\u7b54\u4e2d\u4e0d\u80fd\u8fdb\u884c\u5e94\u7b54");
        }
    }

    private Long addApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO) {
        long replyId = BcmIdUtil.nextId();
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderSupplierReplyPO.class);
        bcmApplyCommodityOrderSupplierReplyPO.setId(BcmIdUtil.nextId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyPO.setReplyUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyUserName(reqBO.getUserName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyOrgId(reqBO.getOrgId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyOrgName(reqBO.getOrgName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyCompanyId(reqBO.getCompanyId());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyCompanyName(reqBO.getCompanyName());
        bcmApplyCommodityOrderSupplierReplyPO.setReplyTime(new Date());
        bcmApplyCommodityOrderSupplierReplyPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
        bcmApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        this.bcmApplyCommodityOrderSupplierReplyMapper.insert(bcmApplyCommodityOrderSupplierReplyPO);
        return replyId;
    }

    private List<BcmApplyCommodityOrderSupplierReplyItemPO> getApplyCommodityOrderSupplierReplyItem(Long replyId) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO bcmQueryApplyCommodityOrderSupplierReplyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setReplyId(replyId);
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return this.bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyItemPO);
    }

    private void updateApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReplyPO = new BcmApplyCommodityOrderSupplierReplyPO();
        bcmApplyCommodityOrderSupplierReplyPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyPO.setUpdateUserName(reqBO.getUserName());
        this.bcmApplyCommodityOrderSupplierReplyMapper.update(bcmApplyCommodityOrderSupplierReplyPO);
    }

    private void addApplyCommodityOrderSupplierReplyItem(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        ArrayList<BcmApplyCommodityOrderSupplierReplyItemPO> list = new ArrayList<BcmApplyCommodityOrderSupplierReplyItemPO>();
        Date now = new Date();
        ArrayList<BcmFilePO> filePOS = new ArrayList<BcmFilePO>();
        for (BcmAddReplyCommodityBO bo : reqBO.getReplyCommodityOrderItemList()) {
            Long replyItemId = BcmIdUtil.nextId();
            BcmApplyCommodityOrderSupplierReplyItemPO po = BcmRuUtil.js(bo, BcmQueryApplyCommodityOrderSupplierReplyItemPO.class);
            po.setId(BcmIdUtil.nextId());
            po.setReplyItemId(replyItemId);
            po.setReplyId(replyId);
            po.setCommodityReplyTypes(bo.getCommodityReplyTypeId());
            po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.NO);
            po.setPushFlag(BcmPersonalCommodityConstant.PushFlag.NO_PUSH);
            po.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
            po.setCreateUserId(reqBO.getUserId());
            po.setCreateUserName(reqBO.getUserName());
            po.setCreateTime(now);
            if (!CollectionUtils.isEmpty((Collection)bo.getFileInfo())) {
                for (BcmFileBO fileBO : bo.getFileInfo()) {
                    BcmFilePO filePO = BcmRuUtil.js(fileBO, BcmFilePO.class);
                    filePO.setBusinessId(replyItemId);
                    filePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
                    filePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
                    filePO.setId(BcmIdUtil.nextId());
                    filePO.setCreateTime(now);
                    filePO.setCreateUserName(reqBO.getUserName());
                    filePO.setCreateUserId(reqBO.getUserId());
                    filePOS.add(filePO);
                }
            }
            list.add(po);
        }
        this.bcmApplyCommodityOrderSupplierReplyItemMapper.insertBatch(list);
        if (!CollectionUtils.isEmpty(filePOS)) {
            this.bcmFileMapper.insertBatch(filePOS);
        }
    }

    private void updateApplyCommodityOrderSupplierReplyItem(BcmAddBatchReplyCommodityReqBO reqBO, Long replyId) {
        BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItemPO = new BcmApplyCommodityOrderSupplierReplyItemPO();
        bcmApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        bcmApplyCommodityOrderSupplierReplyItemPO.setReplyId(replyId);
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderSupplierReplyItemPO.setUpdateUserName(reqBO.getUserName());
        this.bcmApplyCommodityOrderSupplierReplyItemMapper.update(bcmApplyCommodityOrderSupplierReplyItemPO);
    }

    private void updateFile(Long replyId) {
        List<BcmApplyCommodityOrderSupplierReplyItemPO> list = this.getApplyCommodityOrderSupplierReplyItem(replyId);
        if (!CollectionUtils.isEmpty(list)) {
            List<Long> businessIdList = list.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyItemId).collect(Collectors.toList());
            BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
            bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
            bcmQueryFilePO.setBusinessIdList(businessIdList);
            bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
            this.bcmFileMapper.update(bcmQueryFilePO);
        }
    }

    private BcmApplyCommodityOrderSupplierReplyPO getApplyCommodityOrderSupplierReply(BcmAddBatchReplyCommodityReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyPO bcmQueryApplyCommodityOrderSupplierReplyPO = new BcmQueryApplyCommodityOrderSupplierReplyPO();
        bcmQueryApplyCommodityOrderSupplierReplyPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmQueryApplyCommodityOrderSupplierReplyPO.setSupplierId(reqBO.getSupplierId());
        bcmQueryApplyCommodityOrderSupplierReplyPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return this.bcmApplyCommodityOrderSupplierReplyMapper.getModel(bcmQueryApplyCommodityOrderSupplierReplyPO);
    }

    private void verifyParam(BcmAddBatchReplyCommodityReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSupplierId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546id\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSupplierName() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4f9b\u5e94\u5546\u540d\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0a\u67b6\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getUserName())) {
            throw new ZTBusinessException("\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3anull");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getReplyCommodityOrderItemList())) {
            for (BcmAddReplyCommodityBO bo : reqBO.getReplyCommodityOrderItemList()) {
                if (bo.getApplyOrderId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e0a\u67b6\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getApplyOrderItemId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e0a\u67b6\u7533\u8bf7\u5355\u660e\u7ec6id\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getCommodityReplyTypeId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u5e94\u7b54\u7c7b\u578bId\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getFirstCatalogId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e00\u7ea7\u7c7b\u76eeid\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getFirstCatalogName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e00\u7ea7\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getSecondaryCatalogId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e8c\u7ea7\u7c7b\u76eeid\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getSecondaryCatalogName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e8c\u7ea7\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getThirdCatalogId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e09\u7ea7\u7ea7\u7c7b\u76eeid\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getThirdCatalogName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e09\u7ea7\u7ea7\u7c7b\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getCommodityTypeId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u7c7b\u578bid\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getCommodityTypeName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getMeterageUnitId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u8ba1\u91cf\u5355\u4f4did\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getMeterageUnitName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u8ba1\u91cf\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getSupplyNum() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4f9b\u5e94\u6570\u91cf\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getSupplyNum() <= 0) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4f9b\u5e94\u6570\u91cf\u5fc5\u987b\u4e3a\u6b63\u6570");
                }
                if (bo.getSalePrice() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u9500\u552e\u4ef7\u683c\u4e0d\u80fd\u4e3anull");
                }
                if (BigDecimal.ZERO.compareTo(bo.getSalePrice()) >= 0) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u9500\u552e\u4ef7\u683c\u5fc5\u987b\u4e3a\u6b63\u6570");
                }
                if (!BcmPersonalCommodityConstant.CommodityReplyTypeId.HITCH.equals(bo.getCommodityReplyTypeId())) continue;
                if (bo.getSkuId() == null) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u5e94\u7b54\u7c7b\u578bId\u4e3a\u6302\u63a5\u5546\u54c1\u65f6\u5546\u54c1id\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getSkuCode())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u5e94\u7b54\u7c7b\u578bId\u4e3a\u6302\u63a5\u5546\u54c1\u65f6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3anull");
                }
                if (StringUtils.isEmpty((Object)bo.getSkuName())) {
                    throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u5e94\u7b54\u7c7b\u578bId\u4e3a\u6302\u63a5\u5546\u54c1\u65f6\u5546\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3anull");
                }
                if (bo.getSupplierShopId() != null) continue;
                throw new ZTBusinessException("\u5165\u53c2\u5e94\u7b54\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u5546\u54c1\u5e94\u7b54\u7c7b\u578bId\u4e3a\u6302\u63a5\u5546\u54c1\u65f6\u5e97\u94faid\u4e0d\u80fd\u4e3anull");
            }
        }
    }
}

