/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmDeleteApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmDeleteApplyCommodityOrderService"})
public class BcmDeleteApplyCommodityOrderServiceImpl
implements BcmDeleteApplyCommodityOrderService {
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;
    @Autowired
    private BcmApplyCommodityOrderItemMapper bcmApplyCommodityOrderItemMapper;
    @Autowired
    private BcmFileMapper bcmFileMapper;

    @PostMapping(value={"deleteApplyCommodityOrder"})
    public BcmDeleteApplyCommodityOrderRspBO deleteApplyCommodityOrder(@RequestBody BcmDeleteApplyCommodityOrderReqBO reqBO) {
        BcmDeleteApplyCommodityOrderRspBO rspBO = new BcmDeleteApplyCommodityOrderRspBO();
        this.verifyParam(reqBO);
        BcmApplyCommodityOrderPO orderPO = this.bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (ObjectUtil.isEmpty((Object)orderPO)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
            return rspBO;
        }
        if (!BcmPersonalApplyOrderStatusEnum.DRAFT.getStatus().equals(orderPO.getApplyOrderStatus())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8be5\u7533\u8bf7\u5355\u4e0d\u5904\u4e8e\u8349\u7a3f\u72b6\u6001,\u4e0d\u80fd\u5220\u9664");
            return rspBO;
        }
        BcmApplyCommodityOrderItemPO orderItemPO = this.bcmApplyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        BcmApplyCommodityOrderPO deleteOrderPo = new BcmApplyCommodityOrderPO();
        deleteOrderPo.setApplyOrderId(reqBO.getApplyOrderId());
        deleteOrderPo.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        this.bcmApplyCommodityOrderMapper.update(deleteOrderPo);
        BcmApplyCommodityOrderItemPO deleteOrderItemPO = new BcmApplyCommodityOrderItemPO();
        deleteOrderItemPO.setApplyOrderId(reqBO.getApplyOrderId());
        deleteOrderItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        this.bcmApplyCommodityOrderItemMapper.updateByOrderItemId(deleteOrderItemPO);
        this.bcmFileMapper.deleteByBusinessId(orderItemPO.getApplyOrderItemId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void verifyParam(BcmDeleteApplyCommodityOrderReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u4e0a\u67b6\u7533\u8bf7\u5355\u5220\u9664\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getApplyOrderId())) {
            throw new ZTBusinessException("\u4e0a\u67b6\u7533\u8bf7\u5355\u5220\u9664\u5165\u53c2\u4e0a\u67b6\u7533\u8bf7\u5355ID\u3010applyOrderId\u3011\u4e3a\u7a7a");
        }
    }
}

