/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmApplyOrderItemBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderDetailRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmReplyApplyOrderItemBO;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.common.bo.BcmFlowTaskBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityCancelTypeEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityReplyTypeEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalIsCustomizedFlagEnum;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyMapper;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyPO;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyPO;
import com.tydic.bcm.personal.po.BcmQueryFilePO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderDetailService"})
public class BcmQueryApplyOrderDetailServiceImpl
implements BcmQueryApplyOrderDetailService {
    @Autowired
    private BcmApplyCommodityOrderMapper applyCommodityOrderMapper;
    @Autowired
    private BcmApplyCommodityOrderItemMapper applyCommodityOrderItemMapper;
    @Autowired
    private BcmFileMapper fileMapper;
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyMapper bcmApplyCommodityOrderSupplierReplyMapper;
    @Autowired
    private BcmFlowTaskMapper bcmFlowTaskMapper;
    @Autowired
    private BcmFlowInstanceMapper bcmFlowInstanceMapper;

    @PostMapping(value={"queryApplyOrderDetail"})
    public BcmQueryApplyOrderDetailRspBO queryApplyOrderDetail(@RequestBody BcmQueryApplyOrderDetailReqBO reqBO) {
        this.verifyParam(reqBO);
        return this.setRspBO(reqBO);
    }

    private BcmQueryApplyOrderDetailRspBO setRspBO(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmFlowTaskBO taskBO = new BcmFlowTaskBO();
        BcmQueryApplyOrderDetailRspBO rspBO = BcmRuUtil.success(BcmQueryApplyOrderDetailRspBO.class);
        if (!StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            taskBO = this.getTask(reqBO);
        }
        BcmApplyOrderBO bcmApplyOrder = this.getBcmApplyCommodityOrder(reqBO);
        bcmApplyOrder.setTask(taskBO);
        BcmApplyOrderItemBO bcmApplyOrderItemBO = this.getBcmApplyCommodityOrderItem(reqBO);
        bcmApplyOrder.setApplyOrderItem(bcmApplyOrderItemBO);
        if (BcmPersonalCommodityConstant.QueryReplyFlag.YES.equals(reqBO.getQueryReplyFlag())) {
            List<BcmReplyApplyOrderItemBO> replyCommodityList = this.getReplyCommodityList(reqBO);
            bcmApplyOrder.setReplyCommodityList(replyCommodityList);
        }
        bcmApplyOrder.setIsCustomizedFlagStr(BcmPersonalIsCustomizedFlagEnum.getStatusDesc((Integer)bcmApplyOrder.getIsCustomizedFlag()));
        rspBO.setApplyOrder(bcmApplyOrder);
        return rspBO;
    }

    private BcmApplyOrderBO getBcmApplyCommodityOrder(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrder = this.applyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrder == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0a\u67b6\u7533\u8bf7\u5355");
        }
        BcmApplyOrderBO bcmApplyOrder = BcmRuUtil.js(bcmApplyCommodityOrder, BcmApplyOrderBO.class);
        bcmApplyOrder.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc((Integer)bcmApplyOrder.getApplyOrderStatus()));
        bcmApplyOrder.setCancelTypeStr(BcmPersonalCommodityCancelTypeEnum.getCancelDesc((Integer)bcmApplyOrder.getCancelType()));
        return bcmApplyOrder;
    }

    private BcmApplyOrderItemBO getBcmApplyCommodityOrderItem(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem = this.applyCommodityOrderItemMapper.queryByApplyOrderId(reqBO.getApplyOrderId());
        if (bcmApplyCommodityOrderItem == null) {
            throw new ZTBusinessException("\u672a\u627e\u5230\u4e0a\u67b6\u7533\u8bf7\u5355\u660e\u7ec6");
        }
        BcmApplyOrderItemBO bcmApplyOrderItemBO = BcmRuUtil.js(bcmApplyCommodityOrderItem, BcmApplyOrderItemBO.class);
        List<BcmFilePO> bcmFileList = this.getFileList(bcmApplyCommodityOrderItem);
        if (CollectionUtils.isNotEmpty(bcmFileList)) {
            bcmApplyOrderItemBO.setFileList(BcmCommonBeanUtil.listCopyProperties(bcmFileList, BcmFileBO.class));
        }
        return bcmApplyOrderItemBO;
    }

    private List<BcmFilePO> getFileList(BcmApplyCommodityOrderItemPO bcmApplyCommodityOrderItem) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessId(bcmApplyCommodityOrderItem.getApplyOrderItemId());
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.APPLY_ORDER_ITEM);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return this.fileMapper.getList(bcmQueryFilePO);
    }

    private List<BcmFilePO> getFileList(List<Long> businessIdList) {
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessIdList(businessIdList);
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.REPLY_ORDER_ITEM);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return this.fileMapper.getList(bcmQueryFilePO);
    }

    private List<BcmReplyApplyOrderItemBO> getReplyCommodityList(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO bcmQueryApplyCommodityOrderSupplierReplyItemPO = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
        if (BcmPersonalCommodityConstant.SelectFlag.YES.equals(reqBO.getSelectFlag())) {
            bcmQueryApplyCommodityOrderSupplierReplyItemPO.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
        }
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmQueryApplyCommodityOrderSupplierReplyItemPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        List<BcmApplyCommodityOrderSupplierReplyItemPO> bcmApplyCommodityOrderSupplierReplyItemPOS = this.bcmApplyCommodityOrderSupplierReplyItemMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyItemPO);
        if (CollectionUtils.isNotEmpty(bcmApplyCommodityOrderSupplierReplyItemPOS)) {
            ArrayList<BcmReplyApplyOrderItemBO> replyCommodityList = new ArrayList<BcmReplyApplyOrderItemBO>(bcmApplyCommodityOrderSupplierReplyItemPOS.size());
            List<Long> replyItemIdList = bcmApplyCommodityOrderSupplierReplyItemPOS.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyItemId).collect(Collectors.toList());
            List<BcmFilePO> filePOS = this.getFileList(replyItemIdList);
            Map<Long, BcmApplyCommodityOrderSupplierReplyPO> supplierReplyPOMap = this.getapplyCommodityOrderSupplierReplyPOMap(bcmApplyCommodityOrderSupplierReplyItemPOS);
            for (BcmApplyCommodityOrderSupplierReplyItemPO po : bcmApplyCommodityOrderSupplierReplyItemPOS) {
                BcmReplyApplyOrderItemBO itemBO = BcmRuUtil.js(po, BcmReplyApplyOrderItemBO.class);
                itemBO.setSelectFlagStr(BcmPersonalCommonStatusEnum.getStatusDesc((Integer)itemBO.getSelectFlag()));
                itemBO.setPushFlagStr(BcmPersonalCommonStatusEnum.getStatusDesc((Integer)itemBO.getPushFlag()));
                itemBO.setCommodityReplyType(po.getCommodityReplyTypes());
                itemBO.setCommodityReplyTypeStr(BcmPersonalCommodityReplyTypeEnum.getStatusDesc((Integer)itemBO.getCommodityReplyType()));
                if (supplierReplyPOMap.get(itemBO.getReplyId()) != null) {
                    itemBO.setSupplierId(supplierReplyPOMap.get(itemBO.getReplyId()).getSupplierId());
                    itemBO.setSupplierName(supplierReplyPOMap.get(itemBO.getReplyId()).getSupplierName());
                }
                replyCommodityList.add(itemBO);
            }
            if (CollectionUtils.isNotEmpty(filePOS)) {
                Map<Long, List<BcmFilePO>> fileMap = filePOS.stream().collect(Collectors.groupingBy(BcmFilePO::getBusinessId));
                for (BcmReplyApplyOrderItemBO itemBO : replyCommodityList) {
                    itemBO.setFileInfo(BcmRuUtil.jsl(fileMap.get(itemBO.getReplyItemId()), BcmFileBO.class));
                }
            }
            return replyCommodityList;
        }
        return new ArrayList<BcmReplyApplyOrderItemBO>();
    }

    private Map<Long, BcmApplyCommodityOrderSupplierReplyPO> getapplyCommodityOrderSupplierReplyPOMap(List<BcmApplyCommodityOrderSupplierReplyItemPO> bcmApplyCommodityOrderSupplierReplyItemPOS) {
        Set replyIdSet = bcmApplyCommodityOrderSupplierReplyItemPOS.stream().map(BcmApplyCommodityOrderSupplierReplyItemPO::getReplyId).collect(Collectors.toSet());
        BcmQueryApplyCommodityOrderSupplierReplyPO bcmQueryApplyCommodityOrderSupplierReplyPO = new BcmQueryApplyCommodityOrderSupplierReplyPO();
        bcmQueryApplyCommodityOrderSupplierReplyPO.setReplyIdList(new ArrayList<Long>(replyIdSet));
        List<BcmApplyCommodityOrderSupplierReplyPO> applyCommodityOrderSupplierReplyPOList = this.bcmApplyCommodityOrderSupplierReplyMapper.getList(bcmQueryApplyCommodityOrderSupplierReplyPO);
        return applyCommodityOrderSupplierReplyPOList.stream().collect(Collectors.toMap(BcmApplyCommodityOrderSupplierReplyPO::getReplyId, v -> v, (k1, k2) -> k2));
    }

    private void verifyParam(BcmQueryApplyOrderDetailReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getApplyOrderId() == null && StringUtils.isEmpty((Object)reqBO.getTaskId())) {
            throw new ZTBusinessException("\u7533\u8bf7\u5355id\u548c\u6d41\u7a0b\u4efb\u52a1id\u4e0d\u80fd\u540c\u65f6\u4e3anull");
        }
    }

    private BcmFlowTaskBO getTask(BcmQueryApplyOrderDetailReqBO reqBO) {
        BcmFlowTaskPO bcmFlowTaskPO = this.bcmFlowTaskMapper.queryByTaskId(reqBO.getTaskId());
        if (bcmFlowTaskPO == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u6d41\u7a0b\u4efb\u52a1\u4fe1\u606f");
        }
        BcmFlowInstancePO bcmFlowInstancePO = new BcmFlowInstancePO();
        bcmFlowInstancePO.setFlowInstId(bcmFlowTaskPO.getFlowInstId());
        BcmFlowInstancePO model = this.bcmFlowInstanceMapper.getModel(bcmFlowInstancePO);
        if (model == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4efb\u52a1\u5b9e\u4f8b\u4fe1\u606f");
        }
        reqBO.setApplyOrderId(model.getObjId());
        return BcmRuUtil.js(bcmFlowTaskPO, BcmFlowTaskBO.class);
    }
}

