/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmSaveOrSubmitReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSaveOrSubmitReplyRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmSaveOrSubmitReplyService"})
public class BcmSaveOrSubmitReplyServiceImpl
implements BcmSaveOrSubmitReplyService {
    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @PostMapping(value={"saveOrSubmitReply"})
    public BcmSaveOrSubmitReplyRspBO saveOrSubmitReply(@RequestBody BcmSaveOrSubmitReplyReqBO reqBO) {
        this.verifyParam(reqBO);
        this.updateApplyCommodityOrderSupplierReplyItem(reqBO);
        if (BcmPersonalCommodityConstant.OperType.SUBMIT.equals(reqBO.getOperType())) {
            this.updateApplyCommodityOrder(reqBO);
        }
        return BcmRuUtil.success(BcmSaveOrSubmitReplyRspBO.class);
    }

    private void updateApplyCommodityOrder(BcmSaveOrSubmitReplyReqBO reqBO) {
        BcmApplyCommodityOrderPO applyCommodityOrderPO = this.bcmApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        if (applyCommodityOrderPO == null) {
            throw new ZTBusinessException("\u672a\u67e5\u8be2\u5230\u4e0a\u67b6\u7533\u8bf7\u5355");
        }
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = new BcmApplyCommodityOrderPO();
        bcmApplyCommodityOrderPO.setApplyOrderId(reqBO.getApplyOrderId());
        bcmApplyCommodityOrderPO.setUpdateTime(new Date());
        bcmApplyCommodityOrderPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityOrderPO.setUpdateUserName(reqBO.getName());
        bcmApplyCommodityOrderPO.setApplyOrderStatus(BcmPersonalApplyOrderStatusEnum.SELECTED.getStatus());
        this.bcmApplyCommodityOrderMapper.update(bcmApplyCommodityOrderPO);
    }

    private void updateApplyCommodityOrderSupplierReplyItem(BcmSaveOrSubmitReplyReqBO reqBO) {
        BcmQueryApplyCommodityOrderSupplierReplyItemPO po;
        ArrayList<BcmQueryApplyCommodityOrderSupplierReplyItemPO> updateList = new ArrayList<BcmQueryApplyCommodityOrderSupplierReplyItemPO>();
        Date now = new Date();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getCancelSelectIdList())) {
            for (Long id : reqBO.getCancelSelectIdList()) {
                po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.NO);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSelectIdList())) {
            for (Long id : reqBO.getSelectIdList()) {
                po = new BcmQueryApplyCommodityOrderSupplierReplyItemPO();
                po.setId(id);
                po.setSelectFlag(BcmPersonalCommodityConstant.SelectFlag.YES);
                po.setUpdateUserId(reqBO.getUserId());
                po.setUpdateUserName(reqBO.getName());
                po.setUpdateTime(now);
                updateList.add(po);
            }
        }
        if (!CollectionUtils.isEmpty(updateList)) {
            this.bcmApplyCommodityOrderSupplierReplyItemMapper.updateBatch(updateList);
        }
    }

    private void verifyParam(BcmSaveOrSubmitReplyReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getApplyOrderId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0a\u67b6\u7533\u8bf7\u5355id\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u4ebaid\u4e0d\u80fd\u4e3anull");
        }
        if (StringUtils.isEmpty((Object)reqBO.getName())) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u4eba\u540d\u79f0\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getOperType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3anull");
        }
    }
}

