/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityCancelTypeEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalIsCustomizedFlagEnum;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderListPagePO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderPageListService"})
public class BcmQueryApplyCommodityOrderPageListServiceImpl
implements BcmQueryApplyCommodityOrderPageListService {
    private static final Logger log = LoggerFactory.getLogger(BcmQueryApplyCommodityOrderPageListServiceImpl.class);
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @PostMapping(value={"queryApplyCommodityOrderPageList"})
    public BcmQueryApplyCommodityOrderPageListRspBO queryApplyCommodityOrderPageList(@RequestBody BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        this.verifyParam(reqBO);
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = this.getBcmApplyCommodityOrderPO(reqBO);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmApplyCommodityOrderListPagePO> list = this.bcmApplyCommodityOrderMapper.getListPage(bcmQueryApplyCommodityOrderPO, (Page<BcmApplyCommodityOrderListPagePO>)page);
        return this.setRspBO(list, (Page<BcmApplyCommodityOrderListPagePO>)page);
    }

    private BcmQueryApplyCommodityOrderPageListRspBO setRspBO(List<BcmApplyCommodityOrderListPagePO> list, Page<BcmApplyCommodityOrderListPagePO> page) {
        BcmQueryApplyCommodityOrderPageListRspBO rspBO = BcmRuUtil.success(BcmQueryApplyCommodityOrderPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list, BcmApplyCommodityOrderPageBO.class));
        if (CollectionUtils.isNotEmpty((Collection)rspBO.getRows())) {
            for (BcmApplyCommodityOrderPageBO bo : rspBO.getRows()) {
                bo.setCancelTypeStr(BcmPersonalCommodityCancelTypeEnum.getCancelDesc((Integer)bo.getCancelType()));
                bo.setIsCustomizedFlagStr(BcmPersonalIsCustomizedFlagEnum.getStatusDesc((Integer)bo.getIsCustomizedFlag()));
                bo.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc((Integer)bo.getApplyOrderStatus()));
                if (BcmPersonalApplyOrderStatusEnum.IN_RESULT_APPROVAL.getStatus().equals(bo.getApplyOrderStatus()) || BcmPersonalApplyOrderStatusEnum.FINISH.getStatus().equals(bo.getApplyOrderStatus())) {
                    bo.setHitchFlag(BcmPersonalCommonStatusEnum.YES.getStatus());
                    bo.setHitchFlagStr(BcmPersonalCommonStatusEnum.YES.getDesc());
                    continue;
                }
                bo.setHitchFlag(BcmPersonalCommonStatusEnum.NO.getStatus());
                bo.setHitchFlagStr(BcmPersonalCommonStatusEnum.NO.getDesc());
            }
        }
        log.info("\u4e0a\u67b6\u7533\u8bf7\u5355\u5217\u8868\u51fa\u53c2{}", (Object)JSONObject.toJSONString((Object)rspBO));
        return rspBO;
    }

    private BcmQueryApplyCommodityOrderPO getBcmApplyCommodityOrderPO(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderPO.class);
        bcmQueryApplyCommodityOrderPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        bcmQueryApplyCommodityOrderPO.setOrderBy("a.CREATE_TIME DESC");
        return bcmQueryApplyCommodityOrderPO;
    }

    private void verifyParam(BcmQueryApplyCommodityOrderPageListReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (reqBO.getSumFlag() == null) {
            throw new ZTBusinessException("\u53c2\u6570\u662f\u5426\u67e5\u8be2\u6c47\u603b\u6570\u636e\u4e0d\u80fd\u4e3anull");
        }
    }
}

