/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncBasicProjectService;
import com.tydic.bcm.personal.common.bo.BcmBasicProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBasicProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncBasicProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmFullSyncBasicProjectService"})
public class BcmFullSyncBasicProjectServiceImpl
implements BcmFullSyncBasicProjectService {
    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    @PostMapping(value={"fullSyncBasicProject"})
    public BcmFullSyncBasicProjectRspBO fullSyncBasicProject(@RequestBody BcmFullSyncBasicProjectReqBO reqBO) {
        this.verifyParam(reqBO);
        this.fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncBasicProjectRspBO.class);
    }

    private void fullSync(BcmFullSyncBasicProjectReqBO reqBO) {
        List<BcmBasicProjectInfoPO> bcmBasicProjectInfoPOS = BcmRuUtil.jsl(reqBO.getBasicProjectList(), BcmBasicProjectInfoPO.class);
        Date now = new Date();
        for (BcmBasicProjectInfoPO po : bcmBasicProjectInfoPOS) {
            if (po.getCreateTime() == null) {
                po.setCreateTime(now);
            }
            if (po.getUpdateTime() == null) {
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        this.bcmBasicProjectInfoMapper.insertBatch(bcmBasicProjectInfoPOS);
    }

    private void verifyParam(BcmFullSyncBasicProjectReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getBasicProjectList())) {
            throw new ZTBusinessException("\u5165\u53c2\u6210\u672c\u4fe1\u606flist\u4e0d\u80fd\u4e3anull");
        }
        for (BcmBasicProjectInfoBO bo : reqBO.getBasicProjectList()) {
            if (StringUtils.isEmpty((Object)bo.getProjectCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProjectName())) {
                throw new ZTBusinessException("\u5165\u53c2\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProOrgCode())) {
                throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u673a\u6784\u7f16\u53f7\u4e0d\u80fd\u4e3anull");
            }
            if (StringUtils.isEmpty((Object)bo.getProOrgName())) {
                throw new ZTBusinessException("\u5165\u53c2\u91c7\u8d2d\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getBudgetMoney() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u9884\u7b97\u91d1\u989d\u4e0d\u80fd\u4e3anull");
            }
            if (bo.getStatus() != null) continue;
            throw new ZTBusinessException("\u5165\u53c2\u72b6\u6001\u4e0d\u80fd\u4e3anull");
        }
    }
}

