/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskRspBO;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService"})
public class BcmUpdateFlowTaskServiceImpl
implements BcmUpdateFlowTaskService {
    private final BcmFlowTaskMapper flowTaskMapper;
    private final BcmFlowInstanceMapper flowInstanceMapper;

    @PostMapping(value={"updateFlowTask"})
    public BcmUpdateFlowTaskRspBO updateFlowTask(@RequestBody BcmUpdateFlowTaskReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getFlowFinishFlag())) {
            BcmFlowInstancePO flowInstance = new BcmFlowInstancePO();
            flowInstance.setId(reqBO.getFlowInstanceId());
            flowInstance.setFlowInstId(reqBO.getFlowInstId());
            flowInstance.setIsFinish(reqBO.getFlowFinishFlag());
            this.flowInstanceMapper.update(flowInstance);
        }
        BcmFlowTaskPO bcmFlowTask = (BcmFlowTaskPO)BeanUtil.copyProperties((Object)reqBO, BcmFlowTaskPO.class);
        this.flowTaskMapper.update(bcmFlowTask);
        return new BcmUpdateFlowTaskRspBO();
    }

    public BcmUpdateFlowTaskServiceImpl(BcmFlowTaskMapper flowTaskMapper, BcmFlowInstanceMapper flowInstanceMapper) {
        this.flowTaskMapper = flowTaskMapper;
        this.flowInstanceMapper = flowInstanceMapper;
    }
}

