/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.settle.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmDeleteBatchBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmDeleteBatchBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmDeleteBatchBondDeductRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"BCM_CENTER_GROUP_DEV/3.0.0/com.tydic.bcm.personal.settle.api.BcmDeleteBatchBondDeductService"})
public class BcmDeleteBatchBondDeductServiceImpl
implements BcmDeleteBatchBondDeductService {
    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @PostMapping(value={"deleteBatchBondDeduct"})
    public BcmDeleteBatchBondDeductRspBO deleteBatchBondDeduct(@RequestBody BcmDeleteBatchBondDeductReqBO reqBO) {
        this.verifyParam(reqBO);
        this.check(reqBO);
        BcmQueryBondDeductInfoPO queryPO = this.getBcmBondDeductInfoPO(reqBO);
        this.bcmBondDeductInfoMapper.updateBatchById(queryPO);
        return BcmRuUtil.success(BcmDeleteBatchBondDeductRspBO.class);
    }

    private void check(BcmDeleteBatchBondDeductReqBO reqBO) {
        BcmQueryBondDeductInfoPO bcmQueryBondDeductInfoPO = new BcmQueryBondDeductInfoPO();
        bcmQueryBondDeductInfoPO.setIds(reqBO.getIds());
        List<BcmBondDeductInfoPO> list = this.bcmBondDeductInfoMapper.getList(bcmQueryBondDeductInfoPO);
        for (BcmBondDeductInfoPO po : list) {
            if (!BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED.equals(po.getDocStatus())) continue;
            throw new ZTBusinessException("\u5b58\u5728\u5df2\u786e\u8ba4\u6570\u636e\uff0c\u5220\u9664\u5931\u8d25");
        }
    }

    private BcmQueryBondDeductInfoPO getBcmBondDeductInfoPO(BcmDeleteBatchBondDeductReqBO reqBO) {
        BcmQueryBondDeductInfoPO queryPO = BcmRuUtil.js(reqBO, BcmQueryBondDeductInfoPO.class);
        queryPO.setUpdateTime(new Date());
        queryPO.setUpdateUserName(reqBO.getUserName());
        queryPO.setUpdateUserId(reqBO.getUserId());
        queryPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.YES);
        return queryPO;
    }

    private void verifyParam(BcmDeleteBatchBondDeductReqBO reqBO) {
        if (reqBO == null) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3anull");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getIds())) {
            throw new ZTBusinessException("\u5165\u53c2\u6570\u636eid\u96c6\u5408\u4e0d\u80fd\u4e3anull");
        }
    }
}

