/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.bcm.personal.utils;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.RandomUtil;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.springframework.stereotype.Component;

@Component
public class BcmIdUtil {
    private static final long START = 1420041600000L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private static long workerId = 0L;
    private static long dataCenterId = 0L;
    private static long sequence = 0L;
    private static long lastTimestamp = -1L;
    private static volatile Snowflake instance = null;

    public static Long nextId() {
        return BcmIdUtil.getInstance().nextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Snowflake getInstance() {
        if (instance != null) return instance;
        Class<IdUtil> clazz = IdUtil.class;
        synchronized (IdUtil.class) {
            if (instance != null) return instance;
            instance = IdUtil.getSnowflake((long)BcmIdUtil.getWorkId(), (long)BcmIdUtil.getDataCenterId());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static Long getWorkId() {
        try {
            String hostAddress = Inet4Address.getLocalHost().getHostAddress();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostAddress);
            int sums = 0;
            for (int b : ints) {
                sums += b;
            }
            return sums % 32;
        }
        catch (UnknownHostException e) {
            return RandomUtil.randomLong((long)31L);
        }
    }

    private static Long getDataCenterId() {
        try {
            String hostName = SystemUtils.getHostName();
            int[] ints = StringUtils.toCodePoints((CharSequence)hostName);
            int sums = 0;
            for (int i : ints) {
                sums += i;
            }
            return sums % 32;
        }
        catch (Exception e) {
            return RandomUtil.randomLong((long)31L);
        }
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = BcmIdUtil.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = BcmIdUtil.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }
}

