package com.tydic.bcm.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmAddITContractTypeService;
import com.tydic.bcm.personal.commodity.bo.BcmAddITContractTypeReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmAddITContractTypeRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmITContractTypeMapper;
import com.tydic.bcm.personal.po.BcmITContractTypePO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题 BcmAddITContractTypeServiceImpl
 * 说明 IT合同类型管理-新增IT合同类型实现
 * 时间 2023/7/19 15:15
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmAddITContractTypeServiceImpl implements BcmAddITContractTypeService {

    @Autowired
    private BcmITContractTypeMapper bcmITContractTypeMapper;

    /**
     * 新增IT合同类型
     * @param reqBO
     * @return
     */
    @Override
    public BcmAddITContractTypeRspBO addITContractType(BcmAddITContractTypeReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmITContractTypePO bcmITContractTypePO = getBcmITContractTypePO(reqBO);
        //新增IT合同类型
        bcmITContractTypeMapper.insert(bcmITContractTypePO);
        return BcmRuUtil.success(BcmAddITContractTypeRspBO.class);
    }


    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmITContractTypePO getBcmITContractTypePO(BcmAddITContractTypeReqBO reqBO){
        BcmITContractTypePO bcmITContractTypePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmITContractTypePO.class);
        bcmITContractTypePO.setId(BcmIdUtil.nextId());
        bcmITContractTypePO.setCreateTime(new Date());
        bcmITContractTypePO.setCreateUserId(reqBO.getUserId());
        bcmITContractTypePO.setCreateUserName(reqBO.getUserName());
        bcmITContractTypePO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmITContractTypePO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmAddITContractTypeReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getContractType())){
            throw new ZTBusinessException("参数合同类型不能为null");
        }
        if(reqBO.getUserId() == null){
            throw new ZTBusinessException("参数操作人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getUserName())){
            throw new ZTBusinessException("操作人名称不能为null");
        }
    }
}
