package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmSelectBatchApplyCommodityOrderSupplierReplyService;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSelectBatchReplyCommodityReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmSelectBatchReplyCommodityRspBO;
import com.tydic.bcm.personal.commodity.bo.BcmSelectReplyCommodityBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderSupplierReplyItemMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 类名： BcmSelectBatchApplyCommodityOrderSupplierReplyServiceImpl
 * 说明：上架申请单应答-选择挂接商品（批量）实现
 *
 * @author： lishiqing
 * 时间： 2023/8/1 14:48
 */
@HTServiceImpl
public class BcmSelectBatchApplyCommodityOrderSupplierReplyServiceImpl implements BcmSelectBatchApplyCommodityOrderSupplierReplyService {

    @Autowired
    private BcmApplyCommodityOrderSupplierReplyItemMapper bcmApplyCommodityOrderSupplierReplyItemMapper;

    @Override
    public BcmSelectBatchReplyCommodityRspBO selectBatchReplyCommodity(BcmSelectBatchReplyCommodityReqBO reqBO) {
        BcmSelectBatchReplyCommodityRspBO rspBO = new BcmSelectBatchReplyCommodityRspBO();
        // 参数校验
        verifyParam(reqBO);

        // 挂接商品
        for (BcmSelectReplyCommodityBO item : reqBO.getReplyCommodityOrderItemList()) {
            if (ObjectUtil.isEmpty(item.getSkuId()) || ObjectUtil.isEmpty(item.getSkuCode())) {
                continue;
            }
            BcmApplyCommodityOrderSupplierReplyItemPO updatePO = new BcmApplyCommodityOrderSupplierReplyItemPO();
            updatePO.setReplyItemId(item.getReplyItemId());
            updatePO.setSkuId(item.getSkuId());
            updatePO.setSkuCode(item.getSkuCode());
            updatePO.setPushFlag(BcmPersonalCommodityConstant.PushFlag.YES_PUSH);
            bcmApplyCommodityOrderSupplierReplyItemMapper.update(updatePO);
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmSelectBatchReplyCommodityReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("选择挂接商品（批量）入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getReplyCommodityOrderItemList())) {
            throw new ZTBusinessException("选择挂接商品（批量）入参应答商品明细集合【replyCommodityOrderItemList】为空");
        }
        reqBO.getReplyCommodityOrderItemList().forEach(item -> {
            if (ObjectUtil.isEmpty(item.getReplyItemId())) {
                throw new ZTBusinessException("选择挂接商品（批量）入参应答商品明细数据ID【replyItemId】为空");
            }
           /* if (ObjectUtil.isEmpty(item.getSkuId())) {
                throw new ZTBusinessException("选择挂接商品（批量）入参商品ID【skuId】为空");
            }
            if (ObjectUtil.isEmpty(item.getSkuCode())) {
                throw new ZTBusinessException("选择挂接商品（批量）入参商品编码【skuCode】为空");
            }*/
        });
    }
}
