package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmDeletePurchasePurposeConfigService;
import com.tydic.bcm.personal.common.bo.BcmDeletePurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmDeletePurchasePurposeConfigRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;
import java.util.List;

/**
 * 类名： BcmDeletePurchasePurposeConfigServiceImpl
 * 说明：采购用途设置-采购用途删除实现
 *
 * @author： lishiqing
 * 时间： 2023/7/21 14:27
 */
@HTServiceImpl
public class BcmDeletePurchasePurposeConfigServiceImpl implements BcmDeletePurchasePurposeConfigService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    /**
     * 采购用途删除
     * @param reqBO
     * @return
     */
    @Override
    public BcmDeletePurchasePurposeConfigRspBO deletePurchasePurposeConfig(BcmDeletePurchasePurposeConfigReqBO reqBO) {
        BcmDeletePurchasePurposeConfigRspBO rspBO = new BcmDeletePurchasePurposeConfigRspBO();
        // 参数校验
        verifyParam(reqBO);

        // 判断是否关联收支项目
        BcmPurchasePurposeAndPaymentProjectRelPO qryPO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        qryPO.setPurchasePurposeId(reqBO.getPurchasePurposeId());
        qryPO.setRelStatus(BcmPersonalCommonConstant.RelStatus.ASSOCIATED);
        List<BcmPurchasePurposeAndPaymentProjectRelPO> bcmPurchasePurposeAndPaymentProjectRelPOList =
                bcmPurchasePurposeAndPaymentProjectRelMapper.getList(qryPO);
        if (!CollectionUtil.isEmpty(bcmPurchasePurposeAndPaymentProjectRelPOList)) {
            throw new ZTBusinessException("采购项目存在关联的收支项目");
        }

        // 入参组装
        BcmPurchasePurposeConfigPO deletePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeConfigPO.class);
        deletePO.setUpdateTime(new Date());
        deletePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.YES);

        // 根据ID修改单条数据
        int i = bcmPurchasePurposeConfigMapper.updateById(deletePO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途删除失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDeletePurchasePurposeConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途删除入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getId())) {
            throw new ZTBusinessException("采购用途删除入参主键【id】为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getId())) {
            throw new ZTBusinessException("采购用途删除入参采购用途ID【purchasePurposeId】为空");
        }
    }
}
