package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncBudgetProjectService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBudgetProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 BcmIncrementSyncBudgetProjectServiceImpl
 * 说明 预算项目查询-预算项目增量同步实现
 * 时间 2023/8/1 15:04
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmIncrementSyncBudgetProjectServiceImpl implements BcmIncrementSyncBudgetProjectService {

    @Autowired
    private BcmBudgetProjectInfoMapper bcmBudgetProjectInfoMapper;

    /**
     * 预算项目增量同步实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmIncrementSyncBudgetProjectRspBO incrementSyncBudgetProject(BcmIncrementSyncBudgetProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //增量同步
        incSyncBudgetProjectR(reqBO);
        return BcmRuUtil.success(BcmIncrementSyncBudgetProjectRspBO.class);
    }

    /**
     * 增量同步
     * @param reqBO
     */
    private void incSyncBudgetProjectR(BcmIncrementSyncBudgetProjectReqBO reqBO){
        List<BcmBudgetProjectInfoPO> addList = new ArrayList<>(reqBO.getChangeList().size());
        List<BcmBudgetProjectInfoPO> updateList = new ArrayList<>(reqBO.getChangeList().size());
        List<String> projectCodeList = getExistProjectCode(reqBO);
        Date now = new Date();
        for (BcmBudgetProjectInfoBO bo:reqBO.getChangeList()) {
            BcmBudgetProjectInfoPO po ;
            //新增
            if(!projectCodeList.contains(bo.getProjectCode())){
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmBudgetProjectInfoPO.class);
                po.setId(BcmIdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if(po.getCreateTime() == null){
                    po.setCreateTime(now);
                }
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                addList.add(po);
            } else{
                //修改
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmBudgetProjectInfoPO.class);
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                updateList.add(po);
            }
        }
        if(!CollectionUtils.isEmpty(addList)){
            bcmBudgetProjectInfoMapper.insertBatch(addList);
        }
        if(!CollectionUtils.isEmpty(updateList)){
            bcmBudgetProjectInfoMapper.updateBatch(updateList);
        }
    }

    /**
     * 获取存在的项目code
     */
    private List<String> getExistProjectCode(BcmIncrementSyncBudgetProjectReqBO reqBO){
        BcmQueryBudgetProjectInfoPO bcmQueryBudgetProjectInfoPO = new BcmQueryBudgetProjectInfoPO();
        bcmQueryBudgetProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmBudgetProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmBudgetProjectInfoPO> list = bcmBudgetProjectInfoMapper.getList(bcmQueryBudgetProjectInfoPO);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        return list.stream().map(BcmBudgetProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmIncrementSyncBudgetProjectReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getChangeList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmBudgetProjectInfoBO bo:reqBO.getChangeList()) {
            if(StringUtils.isEmpty(bo.getProjectCode())){
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getProjectName())){
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())){
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getFinancialOrgName())){
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
