package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmIncrementSyncPaymentProjectService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题 BcmIncrementSyncPaymentProjectServiceImpl
 * 说明 收支项目查询-收支项目增量同步实现
 * 时间 2023/8/1 10:49
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmIncrementSyncPaymentProjectServiceImpl implements BcmIncrementSyncPaymentProjectService {

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    /**
     * 收支项目增量同步实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmIncrementSyncPaymentProjectRspBO incrementSyncPaymentProject(BcmIncrementSyncPaymentProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //增量同步
        incSyncPaymentProject(reqBO);
        return BcmRuUtil.success(BcmIncrementSyncPaymentProjectRspBO.class);
    }

    /**
     * 增量同步
     * @param reqBO
     */
    private void incSyncPaymentProject(BcmIncrementSyncPaymentProjectReqBO reqBO){
        List<BcmPaymentProjectInfoPO> addList = new ArrayList<>(reqBO.getChangeList().size());
        List<BcmPaymentProjectInfoPO> updateList = new ArrayList<>(reqBO.getChangeList().size());
        Date now = new Date();
        List<String> projectCodeList = getExistProjectCode(reqBO);
        for (BcmPaymentProjectInfoBO bo:reqBO.getChangeList()) {
            BcmPaymentProjectInfoPO po ;
            //新增
            if(!projectCodeList.contains(bo.getProjectCode())){
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmPaymentProjectInfoPO.class);
                po.setId(BcmIdUtil.nextId());
                po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                if(po.getCreateTime() == null){
                    po.setCreateTime(now);
                }
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                addList.add(po);
            } else {
                //修改
                po = JSONObject.parseObject(JSONObject.toJSONString(bo),BcmPaymentProjectInfoPO.class);
                if(po.getUpdateTime() == null){
                    po.setUpdateTime(now);
                }
                updateList.add(po);
            }
        }
        if(!CollectionUtils.isEmpty(addList)){
            bcmPaymentProjectInfoMapper.insertBatch(addList);
        }
        if(!CollectionUtils.isEmpty(updateList)){
            bcmPaymentProjectInfoMapper.updateBatch(updateList);
        }
    }

    /**
     * 获取存在的项目code
     */
    private List<String> getExistProjectCode(BcmIncrementSyncPaymentProjectReqBO reqBO){
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = new BcmQueryPaymentProjectInfoPO();
        bcmQueryPaymentProjectInfoPO.setProjectCodeList(reqBO.getChangeList().stream().map(BcmPaymentProjectInfoBO::getProjectCode).collect(Collectors.toList()));
        List<BcmPaymentProjectInfoPO> list = bcmPaymentProjectInfoMapper.getList(bcmQueryPaymentProjectInfoPO);
        if(CollectionUtils.isEmpty(list)){
            return new ArrayList<>();
        }
        return list.stream().map(BcmPaymentProjectInfoPO::getProjectCode).collect(Collectors.toList());
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmIncrementSyncPaymentProjectReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getChangeList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmPaymentProjectInfoBO bo:reqBO.getChangeList()) {
            if(StringUtils.isEmpty(bo.getProjectCode())){
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getProjectName())){
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())){
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getFinancialOrgName())){
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
