package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryBasicProjectPageListService;
import com.tydic.bcm.personal.common.bo.BcmBasicProjectInfoBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBasicProjectPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryBasicProjectPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryBasicProjectPageListServiceImpl
 * 说明 项目基本信息-项目基本信息列表查询（分页）实现
 * 时间 2023/7/21 11:04
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBasicProjectPageListServiceImpl implements BcmQueryBasicProjectPageListService {

    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    /**
     * 项目基本信息列表查询（分页）
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBasicProjectPageListRspBO queryBasicProjectPageList(BcmQueryBasicProjectPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = getBcmQueryBasicProjectInfoPO(reqBO);
        Page<BcmBasicProjectInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        //项目基本信息列表查询
        List<BcmBasicProjectInfoPO> list = bcmBasicProjectInfoMapper.getListPage(bcmQueryBasicProjectInfoPO, page);
        return setRspBO(list,page);
    }

    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryBasicProjectPageListRspBO setRspBO(List<BcmBasicProjectInfoPO> list,Page<BcmBasicProjectInfoPO> page){
        BcmQueryBasicProjectPageListRspBO rspBO = BcmRuUtil.success(BcmQueryBasicProjectPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list, BcmBasicProjectInfoBO.class));
        return rspBO;
    }
    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryBasicProjectInfoPO getBcmQueryBasicProjectInfoPO(BcmQueryBasicProjectPageListReqBO reqBO){
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmQueryBasicProjectInfoPO.class);
        bcmQueryBasicProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryBasicProjectInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmQueryBasicProjectInfoPO;
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryBasicProjectPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
