package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmQuerySuggestedDetailService;
import com.tydic.bcm.personal.common.bo.BcmFileBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedDetailReqBO;
import com.tydic.bcm.personal.common.bo.BcmQuerySuggestedDetailRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmFileMapper;
import com.tydic.bcm.personal.dao.BcmSuggestedManagementInfoMapper;
import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmQueryFilePO;
import com.tydic.bcm.personal.po.BcmSuggestedManagementInfoPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmSaasQuerySuggestedDetailServiceImpl
 * 说明 建议管理-查询建议详情实现
 * 时间 2023/7/24 11:49
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQuerySuggestedDetailServiceImpl implements BcmQuerySuggestedDetailService {

    /**
     * 我的建议Mapper
     */
    @Autowired
    private BcmSuggestedManagementInfoMapper bcmSuggestedManagementInfoMapper;

    /**
     * 附件信息Mapper
     */
    @Autowired
    private BcmFileMapper bcmFileMapper;

    /**
     * 查询建议详情
     * @param reqBO
     * @return
     */
    @Override
    public BcmQuerySuggestedDetailRspBO querySuggestedDetail(BcmQuerySuggestedDetailReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        return setRspBO(reqBO);
    }

    /**
     * 建议详情获取
     * @param reqBO
     * @return
     */
    private BcmSuggestedManagementInfoPO getSuggestedDetail(BcmQuerySuggestedDetailReqBO reqBO){
        BcmSuggestedManagementInfoPO bcmSuggestedManagementInfoPO = new BcmSuggestedManagementInfoPO();
        bcmSuggestedManagementInfoPO.setSuggestedId(reqBO.getSuggestedId());
        BcmSuggestedManagementInfoPO modelBy = bcmSuggestedManagementInfoMapper.getModelBy(bcmSuggestedManagementInfoPO);
        return modelBy;
    }

    /**
     * 附件信息集合获取
     * @param reqBO
     * @return
     */
    private List<BcmFilePO> getFileList(BcmQuerySuggestedDetailReqBO reqBO){
        BcmQueryFilePO bcmQueryFilePO = new BcmQueryFilePO();
        bcmQueryFilePO.setBusinessId(reqBO.getSuggestedId());
        bcmQueryFilePO.setBusinessType(BcmPersonalCommonConstant.BusinessType.SUGGESTION);
        bcmQueryFilePO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
       return bcmFileMapper.getList(bcmQueryFilePO);
    }

    /**
     * 出参组装
     * @param reqBO
     * @return
     */
    private BcmQuerySuggestedDetailRspBO setRspBO(BcmQuerySuggestedDetailReqBO reqBO){
        //建议信息详情
        BcmQuerySuggestedDetailRspBO rspBO = BcmRuUtil.js(getSuggestedDetail(reqBO),BcmQuerySuggestedDetailRspBO.class);
        //建议匿名设置
        if(BcmPersonalCommonConstant.IsAnonymous.YES.equals(rspBO.getIsAnonymous())){
            rspBO.setSuggestedUserId(null);
            rspBO.setSuggestedUserName("***");
            rspBO.setSuggestedOrgId(null);
            rspBO.setSuggestedOrgName("***");
            rspBO.setSuggestedCompanyId(null);
            rspBO.setSuggestedCompanyName("***");
        }
        //栏目翻译
        if(BcmPersonalCommonConstant.SuggestedColumn.BUSINESS_EXCHANGE.toString().equals(rspBO.getSuggestedColumn())){
            rspBO.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.BUSINESS_EXCHANGE_STR);
        } else if(BcmPersonalCommonConstant.SuggestedColumn.PROBLEM_FEEDBACK.toString().equals(rspBO.getSuggestedColumn())){
            rspBO.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.PROBLEM_FEEDBACK_STR);
        }else if(BcmPersonalCommonConstant.SuggestedColumn.SYSTEM_SUGGESTION.toString().equals(rspBO.getSuggestedColumn())){
            rspBO.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.SYSTEM_SUGGESTION_STR);
        }else if(BcmPersonalCommonConstant.SuggestedColumn.VIOLATION_FEEDBACK.toString().equals(rspBO.getSuggestedColumn())){
            rspBO.setSuggestedColumnStr(BcmPersonalCommonConstant.SuggestedColumn.VIOLATION_FEEDBACK_STR);
        }
        //附件信息集合
        rspBO.setFileBoList(BcmRuUtil.jsl(getFileList(reqBO), BcmFileBO.class));
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQuerySuggestedDetailReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("查询建议详情入参为null");
        }
        if(reqBO.getSuggestedId() == null){
            throw new ZTBusinessException("入参建议单id不能为null");
        }

    }
}
