package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import com.tydic.bcm.personal.common.api.BcmUpdateFlowTaskService;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdateFlowTaskRspBO;
import com.tydic.bcm.personal.constants.BooleanFlagEnum;
import com.tydic.bcm.personal.dao.BcmFlowInstanceMapper;
import com.tydic.bcm.personal.dao.BcmFlowTaskMapper;
import com.tydic.bcm.personal.po.BcmFlowInstancePO;
import com.tydic.bcm.personal.po.BcmFlowTaskPO;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/2 18:10
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmUpdateFlowTaskServiceImpl implements BcmUpdateFlowTaskService {

    private final BcmFlowTaskMapper flowTaskMapper;

    private final BcmFlowInstanceMapper flowInstanceMapper;

    @Override
    public BcmUpdateFlowTaskRspBO updateFlowTask(BcmUpdateFlowTaskReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        //流程完结
        if (BooleanFlagEnum.YES.getFlag().equals(reqBO.getFlowFinishFlag())) {
            BcmFlowInstancePO flowInstance = new BcmFlowInstancePO();
            flowInstance.setId(reqBO.getFlowInstanceId());
            flowInstance.setFlowInstId(reqBO.getFlowInstId());
            flowInstance.setIsFinish(reqBO.getFlowFinishFlag());
            flowInstanceMapper.update(flowInstance);
        }

        BcmFlowTaskPO bcmFlowTask = BeanUtil.copyProperties(reqBO, BcmFlowTaskPO.class);
        flowTaskMapper.update(bcmFlowTask);
        return new BcmUpdateFlowTaskRspBO();
    }
}
