package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmUpdatePurchasePurposeConfigService;
import com.tydic.bcm.personal.common.bo.BcmAddPurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdatePurchasePurposeConfigReqBO;
import com.tydic.bcm.personal.common.bo.BcmUpdatePurchasePurposeConfigRspBO;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeConfigMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeConfigPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 类名： BcmUpdatePurchasePurposeConfigServiceImpl
 * 说明：采购用途设置-采购用途修改实现
 *
 * @author： lishiqing
 * 时间： 2023/7/21 14:11
 */
@HTServiceImpl
public class BcmUpdatePurchasePurposeConfigServiceImpl implements BcmUpdatePurchasePurposeConfigService {

    @Autowired
    private BcmPurchasePurposeConfigMapper bcmPurchasePurposeConfigMapper;

    /**
     * 采购用途修改
     * @param reqBO
     * @return
     */
    @Override
    public BcmUpdatePurchasePurposeConfigRspBO updatePurchasePurposeConfig(BcmUpdatePurchasePurposeConfigReqBO reqBO) {
        BcmUpdatePurchasePurposeConfigRspBO rspBO = new BcmUpdatePurchasePurposeConfigRspBO();
        // 参数校验
        verifyParam(reqBO);

        //入参组装
        BcmPurchasePurposeConfigPO updatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmPurchasePurposeConfigPO.class);
        updatePO.setUpdateTime(new Date());

        // 根据ID修改单条数据
        int i = bcmPurchasePurposeConfigMapper.updateById(updatePO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途修改失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }


    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmUpdatePurchasePurposeConfigReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途修改入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getId())) {
            throw new ZTBusinessException("采购用途修改入参采购用途名称【id】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getPurchasePurposeName())) {
            throw new ZTBusinessException("采购用途修改入参采购用途名称【purchasePurposeName】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getFirstCatalogId())) {
            throw new ZTBusinessException("采购用途修改入参一级商品类目ID【firstCatalogId】不能为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getFirstCatalogName())) {
            throw new ZTBusinessException("采购用途修改入参一级商品类目名称【firstCatalogName】不能为空");
        }
    }
}
