package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyItemPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyItemPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商应答明细;(bcm_apply_commodity_order_supplier_reply_item)表数据库访问层
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmApplyCommodityOrderSupplierReplyItemMapper{
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BcmApplyCommodityOrderSupplierReplyItemPO queryById(Long id);
 /**
     * 统计总行数
     *
     * @param bcmApplyCommodityOrderSupplierReplyItem 查询条件
     * @return 总行数
     */
    long count(BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItem);
    /**
     * 新增数据
     *
     * @param bcmApplyCommodityOrderSupplierReplyItem 实例对象
     * @return 影响行数
     */
    int insert(BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItem);
    /**
     * 批量新增数据
     *
     * @param entities List<BcmApplyCommodityOrderSupplierReplyItem> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmApplyCommodityOrderSupplierReplyItemPO> entities);
    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmApplyCommodityOrderSupplierReplyItem> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmApplyCommodityOrderSupplierReplyItemPO> entities);
    /**
     * 更新数据
     *
     * @param bcmApplyCommodityOrderSupplierReplyItem 实例对象
     * @return 影响行数
     */
    int update(BcmApplyCommodityOrderSupplierReplyItemPO bcmApplyCommodityOrderSupplierReplyItem);
    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 应答明细列表查询
     * @param po
     * @return
     */
    List<BcmApplyCommodityOrderSupplierReplyItemPO> getList(BcmQueryApplyCommodityOrderSupplierReplyItemPO po);

   /**
    * 批量修改
    * @param list
    */
   void updateBatch(List<BcmQueryApplyCommodityOrderSupplierReplyItemPO> list);
}