package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmApplyCommodityOrderSupplierReplyPO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderSupplierReplyPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 供应商应答表;(bcm_apply_commodity_order_supplier_reply)表数据库访问层
 *
 * @author : civism
 * @date : 2023-7-28
 */
@Mapper
public interface BcmApplyCommodityOrderSupplierReplyMapper {
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BcmApplyCommodityOrderSupplierReplyPO queryById(Long id);

    /**
     * 根据条件查询单条数据
     * @param po
     * @return
     */
    BcmApplyCommodityOrderSupplierReplyPO getModel(BcmQueryApplyCommodityOrderSupplierReplyPO po);

    /**
     * 统计总行数
     *
     * @param bcmApplyCommodityOrderSupplierReply 查询条件
     * @return 总行数
     */
    long count(BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReply);

    /**
     * 新增数据
     *
     * @param bcmApplyCommodityOrderSupplierReply 实例对象
     * @return 影响行数
     */
    int insert(BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReply);

    /**
     * 批量新增数据
     *
     * @param entities List<BcmApplyCommodityOrderSupplierReply> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<BcmApplyCommodityOrderSupplierReplyPO> entities);

    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<BcmApplyCommodityOrderSupplierReply> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<BcmApplyCommodityOrderSupplierReplyPO> entities);

    /**
     * 更新数据
     *
     * @param bcmApplyCommodityOrderSupplierReply 实例对象
     * @return 影响行数
     */
    int update(BcmApplyCommodityOrderSupplierReplyPO bcmApplyCommodityOrderSupplierReply);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);


    /**
     * 列表查询
     *
     * @param po
     * @return
     */
    List<BcmApplyCommodityOrderSupplierReplyPO> getList(BcmQueryApplyCommodityOrderSupplierReplyPO po);
}