package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBudgetProjectInfoPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmBudgetProjectInfoMapper
 * 说明 预算项目Mapper
 * 时间 2023/7/21 14:04
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmBudgetProjectInfoMapper {

    /**
     * 预算列表查询（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmBudgetProjectInfoPO> getListPage(BcmQueryBudgetProjectInfoPO po, Page<BcmBudgetProjectInfoPO> page);

    /**
     * 批量插入
     * @param list
     */
    void insertBatch(@Param("list") List<BcmBudgetProjectInfoPO> list);

    /**
     * 批量更新
     * @param list
     */
    void updateBatch(@Param("list") List<BcmBudgetProjectInfoPO> list);


    /**
     * 预算列表查询
     * @param po
     * @return
     */
    List<BcmBudgetProjectInfoPO> getList(BcmQueryBudgetProjectInfoPO po);

    /**
     * 根据条件更新信息
     * @param set
     * @param where
     */
    void updateBy(@Param("set") BcmBudgetProjectInfoPO set, @Param("where") BcmBudgetProjectInfoPO where);
}
