package com.tydic.bcm.personal.dao;

import com.tydic.bcm.personal.po.BcmFilePO;
import com.tydic.bcm.personal.po.BcmQueryFilePO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmFileMapper
 * 说明 附件信息Mapper
 * 时间 2023/7/24 12:00
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmFileMapper {

    /**
     * 附件信息列表查询
     * @param po
     * @return
     */
    List<BcmFilePO> getList(BcmQueryFilePO po);

    /**
     * 批量插入数据
     * @param list 参数列表
     * @return int 影响数量
     */
    int insertBatch(List<BcmFilePO> list);

    /**
     * 根据业务id删除文件
     * @param businessId
     * @return
     */
    int deleteByBusinessId(Long businessId);


    /**
     * 更加条件更新数据
     * @param po
     */
    void update(BcmQueryFilePO po);
}
