package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmITContractTypePO;
import com.tydic.bcm.personal.po.BcmQueryITContractTypePO;
import org.apache.ibatis.annotations.Mapper;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmITContractTypeMapper
 * 说明 IT合同类型Mapper
 * 时间 2023/7/19 15:18
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmITContractTypeMapper {

    /**
     * 新增IT合同类型数据
     * @param po
     */
    void insert(BcmITContractTypePO po);

    /**
     * 更新IT合同类型数据
     * @param po
     */
    void updateById(BcmITContractTypePO po);

    /**
     * 列表查询（分页）
     * @param po
     * @param page
     * @return
     */
    List<BcmITContractTypePO> getListPage(BcmQueryITContractTypePO po, Page<BcmITContractTypePO> page);
}
