package com.tydic.bcm.personal.dao;


import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmOrgOrgsFmisPO;
import com.tydic.bcm.personal.po.BcmQueryOrgOrgsFmisPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 标题 BcmQueryOrgOrgsFmisPO
 * 说明 财务组织;NC基础数据临时表：财务组织Mapper
 * 时间 2023/8/15 11:02
 *
 * @author 唐富强
 */
@Mapper
@Repository
public interface BcmOrgOrgsFmisMapper {

    /**
     * 分页查询
     *
     * @param po
     * @param page
     * @return
     */
    List<BcmOrgOrgsFmisPO> getPageList(BcmQueryOrgOrgsFmisPO po, Page<BcmOrgOrgsFmisPO> page);


    /**
     * 列表查询
     *
     * @param po
     * @return
     */
    List<BcmOrgOrgsFmisPO> getList(BcmQueryOrgOrgsFmisPO po);

    /**
     * 根据id批量更新
     *
     * @param po
     */
    void updateBatchById(BcmQueryOrgOrgsFmisPO po);

    /**
     * 更具组织机构ID获取最新的组织信息
     * @return
     */
    BcmOrgOrgsFmisPO getLastData(@Param("pkOrg") String pkOrg);
}