package com.tydic.bcm.personal.po;

import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmApplyCommodityOrderPagePO
 * 说明 上架申请单--持久化对象--查询
 * 时间 2023/7/31 14:11
 *
 * @author lishiqing
 */
@Data
public class BcmApplyCommodityOrderPagePO extends BcmApplyCommodityOrderPO {
    private static final long serialVersionUID = -6679657435382523574L;
    /**
     * 任务ID
     */
    private Long taskId;

    /**
     * 任务状态
     */
    private Integer taskStatus;

    /**
     * 购买开始时段
     */
    private Date buyStartTime;

    /**
     * 购买结束时段
     */
    private Date buyEndTime;

    /**
     * 回应商家数量
     */
    private Integer replySupplierNum;

    /**
     * 选定上架数量
     */
    private Integer selectSupplierNum;

    /**
     * 回应商品数量
     */
    private Integer replyCommodityNum;

    /**
     * 选定商品数量
     */
    private Integer selectCommodityNum;

    /**
     * 上架申请单审批通过时间
     */
    private Date  applyApprovePassTime;

    /**
     * 选定审核通过时间
     */
    private Date selectApprovePassTime;

    /**
     * 提交开始时间
     */
    private Date createStartTime;

    /**
     * 提交结束时间
     */
    private Date createEndTime;

    /**
     * 截止应答开始时间
     */
    private Date replyDeadlineStartDate;

    /**
     * 截止应答结束时间
     */
    private Date replyDeadlineEndDate;

    /**
     * 任务状态
     * 任务状态1待审核2已通过3已驳回4已取消
     */
    private List<Integer> taskStatusList;

    /**
     * 是否查询汇总数据 0是1否
     */
    private Integer sumFlag;

    /**
     * 流程类型：
     * 1：上架申请审批
     * 2：上架申请选定结果审批
     */
    private Integer flowType;

    /**
     * 待审人ID
     */
    private Long pendingAuditUserId;

    /**
     * 审批人ID
     */
    private Long auditUserId;

    /**
     * 排序字段名称
     */
    private String sortName;
    /**
     * 排序顺序(需要接口支持，传值例如：asc、desc)
     */
    private String sortOrder;
}
