package com.tydic.bcm.personal.po;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmQueryPaymentProjectInfoPO
 * 说明 收支项目查询PO
 * 时间 2023/8/1 17:34
 *
 * @author 唐富强
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class BcmQueryPaymentProjectInfoPO extends BcmPaymentProjectInfoPO {
    private static final long serialVersionUID = 3194801866150329179L;
    /**
     * 更新开始时间
     */
    private Date updateStartTime;

    /**
     * 更新结束时间
     */
    private Date updateEndTime;

    /**
     * 排序
     */
    private String orderBy;

    /**
     * 采购用途ID
     */
    private Long purchasePurposeId;

    /**
     * 项目编号集合
     */
    private List<String> projectCodeList;

    /**
     * 项目主键集合
     */
    private List<String> projectIdList;

    /**
     * 公司ID
     */
    private Long createCompanyId;

    /**
     * 收支项目名称
     */
    private String paymentProjectName;
}
