package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 类名： BcmUserInfoGuwpPO
 * 说明：用户表--持久化对象
 *
 * @author： lishiqing
 * 时间： 2023/8/16 11:36
 */
@Data
public class BcmUserInfoGuwpPO implements Serializable {
    private static final long serialVersionUID = -5658458475533684819L;
    /**
     * 主键ID
     */
    private Long id;

    /**
     * 用户主键
     */
    private Long userId;

    /**
     * 机构ID
     */
    private Long orgId;

    /**
     * 用户编码
     */
    private String userCode;

    /**
     * 用户登录名
     */
    private String loginName;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 用户中文名
     */
    private String userName;

    /**
     * 用户名拼音
     */
    private String spellName;

    /**
     * 用户性别
     */
    private String gender;

    /**
     * 用户邮箱
     */
    private String email;

    /**
     * 用户状态
     */
    private String userStatus;

    /**
     * 用户生效日期
     */
    private Date userEffectiveDate;

    /**
     * 用户失效日期
     */
    private Date userExpireDate;

    /**
     * 创建日期
     */
    private Date createTime;

    /**
     * 更新者
     */
    private Long modifyUser;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 用户ehr职位
     */
    private String ehrPosition;

    /**
     * 推送时间
     */
    private Date pushTime;

    /**
     * 处理时间
     */
    private Date dealTime;

    /**
     * 处理结果
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING：待同步
     */
    private String dealResult;
}
