package com.tydic.bcm.personal.settle.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmQueryBondDeductPageListService;
import com.tydic.bcm.personal.settle.bo.BcmBondDeductInfoBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBondDeductPageListReqBO;
import com.tydic.bcm.personal.settle.bo.BcmQueryBondDeductPageListRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 BcmQueryBondDeductPageListServiceImpl
 * 说明 保证金管理-保证金扣除申请单列表查询（分页）实现
 * 时间 2023/7/25 10:06
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryBondDeductPageListServiceImpl implements BcmQueryBondDeductPageListService {

    @Autowired
    private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;


    /**
     * 保证金扣除申请单列表查询（分页）
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryBondDeductPageListRspBO queryBondDeductPageList(BcmQueryBondDeductPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        BcmQueryBondDeductInfoPO bcmQueryBondDeductInfoPO = getBcmBondDeductInfoPO(reqBO);
        Page<BcmBondDeductInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        List<BcmBondDeductInfoPO> list = bcmBondDeductInfoMapper.getListPage(bcmQueryBondDeductInfoPO, page);
        return setRspBO(list,page);
    }

    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryBondDeductPageListRspBO setRspBO(List<BcmBondDeductInfoPO> list,Page<BcmBondDeductInfoPO> page){
        BcmQueryBondDeductPageListRspBO rspBO = BcmRuUtil.success(BcmQueryBondDeductPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list,BcmBondDeductInfoBO.class));
        //状态翻译
        if(!CollectionUtils.isEmpty(rspBO.getRows())){
            for (BcmBondDeductInfoBO bo:rspBO.getRows()){
                if(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING.equals(bo.getDocStatus())){
                    bo.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMING_STR);
                }else if(BcmPersonalSettleConstant.BondDeductStatus.DECLINED.equals(bo.getDocStatus())){
                    bo.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.DECLINED_STR);
                }else if(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED.equals(bo.getDocStatus())){
                    bo.setDocStatusStr(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED_STR);
                }
            }
        }
        return rspBO;
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryBondDeductInfoPO getBcmBondDeductInfoPO(BcmQueryBondDeductPageListReqBO reqBO) {
        BcmQueryBondDeductInfoPO bcmQueryBondDeductInfoPO = BcmRuUtil.js(reqBO, BcmQueryBondDeductInfoPO.class);
        bcmQueryBondDeductInfoPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.NO);
        bcmQueryBondDeductInfoPO.setOrderBy("CREATE_TIME DESC");
        return bcmQueryBondDeductInfoPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryBondDeductPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
