package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.*;
import com.tydic.bcm.personal.po.*;
import com.tydic.bcm.personal.task.api.BcmPaymentProjectSyncTaskService;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmPaymentProjectSyncTaskServiceImpl
 * 说明：收支项目同步比对任务实现
 *
 * @author： lishiqing
 * 时间： 2023/8/15 12:49
 */
@HTServiceImpl
public class BcmPaymentProjectSyncTaskServiceImpl implements BcmPaymentProjectSyncTaskService {

    @Autowired
    private BcmBdInoutbusiclassFmisMapper bcmBdInoutbusiclassFmisMapper;

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    @Autowired
    private BcmOrgOrgsFmisMapper bcmOrgOrgsFmisMapper;

    private static final Integer delPage = 1;

    @Value("${DEAL_COUNT:100}")
    private Integer dealCount;

    private static final Long defaultUserId = 1L;

    private static final String defaultUserName = "系统管理员";

    @Override
    public void syncPaymentProject() {
        // 默认查第一页
        int pageNo = delPage;
        // 循环、分页查询TB_BUDGETSUB_FMIS表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
        BcmBdInoutbusiclassFmisPO qryPO = new BcmBdInoutbusiclassFmisPO();
        qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
        while (true) {
            Page<BcmBdInoutbusiclassFmisPO> page = new Page<>(pageNo,dealCount);
            List<BcmBdInoutbusiclassFmisPO> pageList = bcmBdInoutbusiclassFmisMapper.getPageList(qryPO, page);
            if (ObjectUtil.isEmpty(pageList)) {
                return;
            }
            // 根据TB_BUDGETSUB_FMIS的PK_OBJ去查询bcm_budget_project_info的PROJECT_ID（批量查询）
            List<String> projectIdList = pageList.stream().map(BcmBdInoutbusiclassFmisPO::getPkInoutbusiclass).collect(Collectors.toList());
            BcmQueryPaymentProjectInfoPO qryProjectPO = new BcmQueryPaymentProjectInfoPO();
            qryProjectPO.setProjectIdList(projectIdList);
            qryProjectPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
            List<BcmPaymentProjectInfoPO> projectInfoPOS = bcmPaymentProjectInfoMapper.getList(qryProjectPO);
            // 新增的集合
            List<BcmPaymentProjectInfoPO> batchInsertPOList = new ArrayList<>();
            // 判断收支项目是否为空,如果不为空则存在更新数据，
            if (ObjectUtil.isNotEmpty(projectInfoPOS)) {
                // 拿到更新的集合
                List<String> updateProjectIds = projectInfoPOS.stream().map(BcmPaymentProjectInfoPO::getProjectId).collect(Collectors.toList());
                Map<String, BcmPaymentProjectInfoPO> updateMap = projectInfoPOS.stream().collect(Collectors.toMap(BcmPaymentProjectInfoPO::getProjectId, Function.identity()));
                // 更新临时表的集合
                // 做更新操作
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.ENABLE);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    if (!updateProjectIds.contains(item.getPkInoutbusiclass())) { //新增
                        // 查询机构信息
                        BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                        if (ObjectUtil.isEmpty(nowOrgPO)) {
                            item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                            continue;
                        }
                        // 入参组装
                        BcmPaymentProjectInfoPO insertPO = new BcmPaymentProjectInfoPO();
                        insertPO.setId(BcmIdUtil.nextId());
                        insertPO.setProjectId(item.getPkInoutbusiclass());
                        insertPO.setProjectCode(item.getCode());
                        insertPO.setProjectName(item.getName());
                        insertPO.setStatus(item.getEnablestate());
                        insertPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                        insertPO.setFinancialOrgCode(nowOrgPO.getCode());
                        insertPO.setFinancialOrgName(nowOrgPO.getName());
                        insertPO.setCreateUserId(defaultUserId);
                        insertPO.setCreateUserName(defaultUserName);
                        insertPO.setCreateTime(new Date());
                        insertPO.setUpdateUserId(defaultUserId);
                        insertPO.setUpdateUserName(defaultUserName);
                        insertPO.setUpdateTime(new Date());
                        insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                        batchInsertPOList.add(insertPO);
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                        continue;
                    }
                    BcmPaymentProjectInfoPO sourcePO = updateMap.get(item.getPkInoutbusiclass());
                    BcmPaymentProjectInfoPO setPO = new BcmPaymentProjectInfoPO();
                    // 判断是否有字段变更
                    if (!item.getName().equals(sourcePO.getProjectName())) {
                        setPO.setProjectName(item.getName());
                    }
                    if (!item.getCode().equals(sourcePO.getProjectCode())) {
                        setPO.setProjectCode(item.getCode());
                    }
                    if (!item.getEnablestate().equals(sourcePO.getStatus())) {
                        setPO.setStatus(item.getEnablestate());
                    }
                    if (!item.getPkOrg().equals(sourcePO.getFinancialOrgId())) {
                        // 查询之后更改值
                        BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                        if (ObjectUtil.isEmpty(nowOrgPO)) {
                            item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                            continue;
                        }
                        setPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                        setPO.setFinancialOrgCode(nowOrgPO.getCode());
                        setPO.setFinancialOrgName(nowOrgPO.getName());
                    }
                    // 如果有值变更,
                    if (ObjectUtil.isNotEmpty(setPO.getProjectCode())
                            || ObjectUtil.isNotEmpty(setPO.getProjectName())
                            || ObjectUtil.isNotEmpty(setPO.getStatus())
                            || ObjectUtil.isNotEmpty(setPO.getFinancialOrgId())
                    ) {
                        setPO.setUpdateUserId(defaultUserId);
                        setPO.setUpdateUserName(defaultUserName);
                        setPO.setUpdateTime(new Date());
                        BcmPaymentProjectInfoPO wherePO = new BcmPaymentProjectInfoPO();
                        wherePO.setId(sourcePO.getId());
                        bcmPaymentProjectInfoMapper.updateBy(setPO,wherePO);
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                    }
                }
            } else {
                for (BcmBdInoutbusiclassFmisPO item : pageList) {
                    // 切换状态
                    if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.DISABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.DISABLE);
                    } else if (item.getEnablestate().equals(BcmPersonalCommonConstant.SourceStatus.ENABLE)) {
                        item.setEnablestate(BcmPersonalCommonConstant.SourceStatus.ENABLE);
                    } else {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }

                    // 查询机构信息
                    BcmOrgOrgsFmisPO nowOrgPO = bcmOrgOrgsFmisMapper.getLastData(item.getPkOrg());
                    if (ObjectUtil.isEmpty(nowOrgPO)) {
                        item.setDealResult(BcmPersonalCommonConstant.DealResult.FAIL);
                        continue;
                    }
                    // 入参组装
                    BcmPaymentProjectInfoPO insertPO = new BcmPaymentProjectInfoPO();
                    insertPO.setId(BcmIdUtil.nextId());
                    insertPO.setProjectId(item.getPkInoutbusiclass());
                    insertPO.setProjectCode(item.getCode());
                    insertPO.setProjectName(item.getName());
                    insertPO.setStatus(item.getEnablestate());
                    insertPO.setFinancialOrgId(nowOrgPO.getPkOrg());
                    insertPO.setFinancialOrgCode(nowOrgPO.getCode());
                    insertPO.setFinancialOrgName(nowOrgPO.getName());
                    insertPO.setCreateUserId(defaultUserId);
                    insertPO.setCreateUserName(defaultUserName);
                    insertPO.setCreateTime(new Date());
                    insertPO.setUpdateUserId(defaultUserId);
                    insertPO.setUpdateUserName(defaultUserName);
                    insertPO.setUpdateTime(new Date());
                    insertPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
                    batchInsertPOList.add(insertPO);
                    item.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                }
            }

            // 处理新增数据
            if (ObjectUtil.isNotEmpty(batchInsertPOList)) {
                bcmPaymentProjectInfoMapper.insertBatch(batchInsertPOList);
            }

            // 批量更新临时表数据
            Map<String, List<BcmBdInoutbusiclassFmisPO>> dealResultMap = pageList.stream().collect(Collectors.groupingBy(BcmBdInoutbusiclassFmisPO::getDealResult));
            Iterator<String> iterator = dealResultMap.keySet().iterator();
            while (iterator.hasNext()) {
                String dealResult = iterator.next();
                List<BcmBdInoutbusiclassFmisPO> dealResultPOList = dealResultMap.get(dealResult);
                List<Long> dealIds = dealResultPOList.stream().map(BcmBdInoutbusiclassFmisPO::getId).collect(Collectors.toList());
                BcmBdInoutbusiclassFmisUpdatePO fmisSetPO = new BcmBdInoutbusiclassFmisUpdatePO();
                fmisSetPO.setDealResult(dealResult);
                fmisSetPO.setDealTime(new Date());
                BcmBdInoutbusiclassFmisUpdatePO fmisWherePO = new BcmBdInoutbusiclassFmisUpdatePO();
                fmisWherePO.setIdList(dealIds);
                bcmBdInoutbusiclassFmisMapper.updateBy(fmisSetPO,fmisWherePO);
            }
            pageNo ++;
        }
    }
}
