package com.tydic.bcm.personal.task.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmSyncLogMapper;
import com.tydic.bcm.personal.dao.BcmUserInfoGuwpMapper;
import com.tydic.bcm.personal.po.BcmSyncLogPO;
import com.tydic.bcm.personal.po.BcmUserInfoGuwpPO;
import com.tydic.bcm.personal.po.BcmUserInfoGuwpQueryPO;
import com.tydic.bcm.personal.po.BcmUserInfoGuwpUpdatePO;
import com.tydic.bcm.personal.task.api.BcmUserSyncTaskService;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 类名： BcmSaasUserSyncTaskServiceImpl
 * 说明：
 *
 * @author： lishiqing
 * 时间： 2023/8/16 11:34
 */
@HTServiceImpl
@Slf4j
public class BcmUserSyncTaskServiceImpl implements BcmUserSyncTaskService {

    @Autowired
    private BcmSyncLogMapper bcmSyncLogMapper;

    @Autowired
    private BcmUserInfoGuwpMapper userInfoGuwpMapper;

    @Value("${DEAL_USER_COUNT:100}")
    private Integer dealCount;

    @Value("${USER_DATA_TYPE:GUWP_USER}")
    private String userDataType;

    @Value("${SYNC_USER_ALL:}")
    private String syncUserAllUrl;

    @Value("${SYNC_USER_INC:}")
    private String syncUserIncUrl;

    private static final Integer delPage = 1;

    @Override
    public void syncUser() {
        // 根据字符串“GUWP_USER”查询SYNC_LOG表中的记录，获取上次执行时间LAST_DATE，如果没有就为空
        BcmSyncLogPO syncLogPO = new BcmSyncLogPO();
        syncLogPO.setDataType(userDataType);
        BcmSyncLogPO bcmSyncLogPO = bcmSyncLogMapper.getModelBy(syncLogPO);
        if (ObjectUtil.isNotEmpty(bcmSyncLogPO) && ObjectUtil.isNotEmpty(bcmSyncLogPO.getLastDate())) {
            // 已经同步过数据，查询以前存在的数据
            BcmUserInfoGuwpQueryPO qryOldPO = new BcmUserInfoGuwpQueryPO();
            qryOldPO.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
            qryOldPO.setPushTime(bcmSyncLogPO.getLastDate());
            List<BcmUserInfoGuwpPO> oldUserPOList = userInfoGuwpMapper.getList(qryOldPO);
            Map<Long, BcmUserInfoGuwpPO> oldUserMap = oldUserPOList.stream().collect(Collectors.
                    toMap(BcmUserInfoGuwpPO::getUserId, Function.identity(), (e1, e2) -> e2));

            // 默认查第一页
            int pageNo = delPage;
            // 循环、分页查询USER_INFO_GUWP表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
            BcmUserInfoGuwpQueryPO qryPO = new BcmUserInfoGuwpQueryPO();
            qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);
            qryPO.setPushStartTime(bcmSyncLogPO.getLastDate());
            while (true) {
                Page<BcmUserInfoGuwpPO> page = new Page<>(pageNo,dealCount);
                List<BcmUserInfoGuwpPO> pageList = userInfoGuwpMapper.getPageList(qryPO, page);
                if (ObjectUtil.isEmpty(pageList)) {
                    // 数据处理完了，修改处理记录
                    BcmSyncLogPO updateLogPO = new BcmSyncLogPO();
                    updateLogPO.setId(bcmSyncLogPO.getId());
                    updateLogPO.setLastDate(new Date());
                    bcmSyncLogMapper.updateById(updateLogPO);
                    return;
                }
                // 成功的就是要同步给能力平台的
                List<BcmUserInfoGuwpPO> successPOList = new ArrayList<>();
                // 未改变的ID集合
                List<Long> skipIdList = new ArrayList<>();
                // 遍历对比
                for (BcmUserInfoGuwpPO newUserPO : pageList ) {

                    // 如果不存在，则是新增
                    if (!oldUserMap.containsKey(newUserPO.getUserId())) {
                        successPOList.add(newUserPO);
                        newUserPO.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                        continue;
                    }

                    // 得到存在的OldUserPO
                    BcmUserInfoGuwpPO oldUserPO = oldUserMap.get(newUserPO.getUserId());
                    // 得到新老对象除了基础数据的变量
                    Long newId = newUserPO.getId();
                    Long oldId = oldUserPO.getId();
                    String newDealResult = newUserPO.getDealResult();
                    String oldDealResult = oldUserPO.getDealResult();
                    Date newPushTime = newUserPO.getPushTime();
                    Date oldPushTime = oldUserPO.getPushTime();

                    // 设置ID未空以便比较值变化
                    oldUserPO.setId(null);
                    newUserPO.setId(null);
                    oldUserPO.setDealResult(null);
                    newUserPO.setDealResult(null);
                    oldUserPO.setPushTime(null);
                    newUserPO.setPushTime(null);
                    int oldHashCode = oldUserPO.hashCode();
                    int newHashCode = newUserPO.hashCode();

                    // 拿到基础数据的Hash码后重新赋值
                    oldUserPO.setId(oldId);
                    oldUserPO.setDealResult(oldDealResult);
                    oldUserPO.setPushTime(oldPushTime);
                    newUserPO.setId(newId);
                    newUserPO.setPushTime(newPushTime);
                    newUserPO.setDealResult(newDealResult);
                    // hash码相同，对象的值也是相同的，所以没变化
                    if (oldHashCode == newHashCode) {
                        skipIdList.add(newUserPO.getId());
                        newUserPO.setDealResult(BcmPersonalCommonConstant.DealResult.SKIP);
                    } else { // 设置未成功
                        successPOList.add(newUserPO);
                        newUserPO.setDealResult(BcmPersonalCommonConstant.DealResult.SUCCESS);
                    }
                }

                //判断无需同步的ID集合
                if (ObjectUtil.isNotEmpty(skipIdList)) {
                    changeDealResult(skipIdList,BcmPersonalCommonConstant.DealResult.SKIP);
                }

                // 如果成功的数据不未空，同步给能力平台
                if (ObjectUtil.isNotEmpty(successPOList)) {
                    doAbilityMethod(successPOList,syncUserIncUrl);
                }
                pageNo ++;
            }
        } else {
            // 默认查第一页
            int pageNo = delPage;
            // 循环、分页查询USER_INFO_GUWP表中的数据：DEAL_RESULT字段为待同步状态的数据，数据处理完或无数据终止循环
            BcmUserInfoGuwpQueryPO qryPO = new BcmUserInfoGuwpQueryPO();
            qryPO.setDealResult(BcmPersonalCommonConstant.DealResult.PENDING);

            while (true) {
                Page<BcmUserInfoGuwpPO> page = new Page<>(pageNo,dealCount);
                List<BcmUserInfoGuwpPO> pageList = userInfoGuwpMapper.getPageList(qryPO, page);
                if (ObjectUtil.isEmpty(pageList)) {
                    // 在sync_log里面新增一条记录
                    BcmSyncLogPO insertLogPO = new BcmSyncLogPO();
                    insertLogPO.setId(BcmIdUtil.nextId());
                    insertLogPO.setDataType(userDataType);
                    insertLogPO.setLastDate(new Date());
                    bcmSyncLogMapper.insert(insertLogPO);
                    return;
                }

                // 调用能力平台
                doAbilityMethod(pageList,syncUserAllUrl);

                pageNo ++;
            }
        }
    }

    private void doAbilityMethod(List<BcmUserInfoGuwpPO> successPOList,String url) {
        List<Long> idList = successPOList.stream().map(BcmUserInfoGuwpPO::getId).collect(Collectors.toList());
        JSONObject reqJson = new JSONObject();
        reqJson.put("syncUserList",JSONObject.toJSON(successPOList));
        String reqStr = reqJson.toString();
        log.info("同步用户调用能力平台入参为：{}", reqStr);
        String rspStr = HttpUtil.post(url, reqStr);
        log.info("同步用户调用能力平台出参为：{}",rspStr);
        // 根据能力平台返回判断
        if (!rspStr.contains("失败")) {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.SUCCESS);
        } else {
            changeDealResult(idList,BcmPersonalCommonConstant.DealResult.FAIL);
        }
    }

    /**
     * 更新状态
     * @param ids
     */
    private void changeDealResult(List<Long> ids,String dealResult) {
        BcmUserInfoGuwpUpdatePO setPO = new BcmUserInfoGuwpUpdatePO();
        setPO.setDealResult(dealResult);
        setPO.setDealTime(new Date());
        BcmUserInfoGuwpUpdatePO wherePO = new BcmUserInfoGuwpUpdatePO();
        wherePO.setIdList(ids);
        userInfoGuwpMapper.updateBy(setPO,wherePO);
    }
}
