package com.tydic.bcm.personal.utils;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.bo.BasePageRspBo;
import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.base.constants.BaseRspConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;


/**
 * @author civism
 * @date 2023/4/2
 * @description
 **/
public class BcmCommonBeanUtil {


    public static <T extends BaseRspBo> T copyPropertiesRespInfo(Object from, Class<T> c) {
        if (from == null) {
            return null;
        }
        try {
            T obj = c.getDeclaredConstructor().newInstance();
            BeanUtils.copyProperties(from, obj);
            obj.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }


    /**
     * 拷贝分页列表
     *
     * @param objectPage  分页信息
     * @param result      结果集
     * @param respBoClass 返回resp类
     * @param bo          返回resp中对象实体类
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T extends BasePageRspBo<R>, R> T copyPagePropertiesRespInfo(Page<?> objectPage, List<?> result, Class<T> respBoClass, Class<R> bo) {
        try {
            T obj = respBoClass.getDeclaredConstructor().newInstance();
            if (CollectionUtils.isEmpty(result)) {
                obj.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
                return obj;
            }
            BeanUtils.copyProperties(objectPage, obj);
            List<R> es = listCopyProperties(result, bo);
            obj.setRows(es);
            obj.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            obj.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }


    /**
     * 拷贝分页列表
     *
     * @param objectPage  分页信息
     * @param result      结果集
     * @param respBoClass 返回resp类
     * @param bo          返回resp中对象实体类
     * @param <T>
     * @param <R>
     * @return
     */
    public static <T extends BasePageRspBo<R>, R> T copyPageProperties(Page<?> objectPage, List<?> result, Class<T> respBoClass, Class<R> bo) {
        try {
            T obj = respBoClass.getDeclaredConstructor().newInstance();
            BeanUtils.copyProperties(objectPage, obj);
            List<R> es = listCopyProperties(result, bo);
            obj.setRows(es);
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> T copyProperties(Object from, Class<T> c) {
        if (from == null) {
            return null;
        }
        try {
            T obj = c.getDeclaredConstructor().newInstance();
            BeanUtils.copyProperties(from, obj);
            return obj;
        } catch (InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> List<T> listCopyProperties(List<?> fromList, Class<T> c) {
        if (CollectionUtils.isEmpty(fromList)) {
            return new ArrayList<>();
        }
        List<T> result = new ArrayList<>(fromList.size());
        fromList.forEach(o -> {
            try {
                T obj = c.getDeclaredConstructor().newInstance();
                BeanUtils.copyProperties(o, obj);
                result.add(obj);
            } catch (InvocationTargetException | InstantiationException | IllegalAccessException |
                     NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        return result;
    }
}
