package com.tydic.bcm.personal.commodity.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmDeleteApplyCompanyConfService;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCompanyConfReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmDeleteApplyCompanyConfRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityConfMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityConfPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题 BcmDeleteApplyCompanyConfServiceImpl
 * 说明 上架申请单-删除配置列表实现
 * 时间 2023/7/28 11:00
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmDeleteApplyCompanyConfServiceImpl implements BcmDeleteApplyCompanyConfService {

    @Autowired
    private BcmApplyCommodityConfMapper bcmApplyCommodityConfMapper;

    /**
     * 删除配置列表实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmDeleteApplyCompanyConfRspBO deleteApplyCompanyConf(BcmDeleteApplyCompanyConfReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmApplyCommodityConfPO bcmApplyCommodityConfPO = getBcmApplyOrderSelTimeLimitConfPO(reqBO);
        bcmApplyCommodityConfMapper.updateById(bcmApplyCommodityConfPO);
        return BcmRuUtil.success(BcmDeleteApplyCompanyConfRspBO.class);
    }

    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmApplyCommodityConfPO getBcmApplyOrderSelTimeLimitConfPO(BcmDeleteApplyCompanyConfReqBO reqBO){
        BcmApplyCommodityConfPO bcmApplyCommodityConfPO = BcmRuUtil.js(reqBO, BcmApplyCommodityConfPO.class);
        bcmApplyCommodityConfPO.setUpdateTime(new Date());
        bcmApplyCommodityConfPO.setUpdateUserId(reqBO.getUserId());
        bcmApplyCommodityConfPO.setUpdateUserName(reqBO.getUserName());
        bcmApplyCommodityConfPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.YES);
        return bcmApplyCommodityConfPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDeleteApplyCompanyConfReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("参数id不能为null");
        }
    }
}
