package com.tydic.bcm.personal.commodity.impl;

import com.tydic.bcm.personal.commodity.api.BcmQueryApplyCommodityOrderListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyCommodityOrderListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderListPagePO;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题 BcmQueryApplyCommodityOrderListServiceImpl
 * 说明 上架申请单列表查询实现
 * 时间 2023/8/22 14:22
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryApplyCommodityOrderListServiceImpl implements BcmQueryApplyCommodityOrderListService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    /**
     * 上架申请单列表查询实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyCommodityOrderListRspBO getList(BcmQueryApplyCommodityOrderListReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = getBcmApplyCommodityOrderPO(reqBO);
        List<BcmApplyCommodityOrderListPagePO> list = bcmApplyCommodityOrderMapper.getList(bcmQueryApplyCommodityOrderPO);
        BcmQueryApplyCommodityOrderListRspBO rspBO = BcmRuUtil.success(BcmQueryApplyCommodityOrderListRspBO.class);
        rspBO.setList(BcmRuUtil.jsl(list, BcmApplyCommodityOrderBO.class));
        return rspBO;
    }

    /**
     * 参数组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryApplyCommodityOrderPO getBcmApplyCommodityOrderPO(BcmQueryApplyCommodityOrderListReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderPO.class);
        bcmQueryApplyCommodityOrderPO.setDelFlag(BcmPersonalCommodityConstant.DelFlag.NO);
        return bcmQueryApplyCommodityOrderPO;
    }
}
