package com.tydic.bcm.personal.commodity.impl;

import com.tydic.bcm.personal.commodity.api.BcmQueryApplyOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryApplyOrderRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题 BcmQueryApplyOrderServiceImpl
 * 说明 查询上架申请单
 * 时间 2023/8/29 11:05
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryApplyOrderServiceImpl implements BcmQueryApplyOrderService {

    @Autowired
    private BcmApplyCommodityOrderMapper bomApplyCommodityOrderMapper;

    /**
     * 查询上架申请单
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryApplyOrderRspBO queryApplyOrder(BcmQueryApplyOrderReqBO reqBO) {
        BcmApplyCommodityOrderPO bcmApplyCommodityOrderPO = bomApplyCommodityOrderMapper.queryByOrderId(reqBO.getApplyOrderId());
        BcmQueryApplyOrderRspBO rspBO = BcmRuUtil.js(bcmApplyCommodityOrderPO, BcmQueryApplyOrderRspBO.class);
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }
}
