package com.tydic.bcm.personal.commodity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.commodity.api.BcmQueryPendingAuditApplyCommodityOrderPageListService;
import com.tydic.bcm.personal.commodity.bo.BcmApplyCommodityOrderPageBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryPendingAuditApplyCommodityOrderPageListReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmQueryPendingAuditApplyCommodityOrderPageListRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalApplyOrderStatusEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommodityConstant;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.constants.BcmPersonalIsCustomizedFlagEnum;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmApplyCommodityOrderPagePO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 类名： BcmQueryPendingAuditApplyCommodityOrderPageListService
 * 说明：上架申请单-待审批列表查询（分页）实现
 *
 * @author： lishiqing
 * 时间： 2023/8/1 9:55
 */
@HTServiceImpl
public class BcmQueryPendingAuditApplyCommodityOrderPageListServiceImpl implements BcmQueryPendingAuditApplyCommodityOrderPageListService {

    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;

    @Override
    public BcmQueryPendingAuditApplyCommodityOrderPageListRspBO queryPendingAuditApplyCommodityOrderPageList(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO) {
        BcmQueryPendingAuditApplyCommodityOrderPageListRspBO rspBO = new BcmQueryPendingAuditApplyCommodityOrderPageListRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        Page<BcmApplyCommodityOrderPagePO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        BcmApplyCommodityOrderPagePO po = JSONObject.parseObject(JSON.toJSONString(reqBO), BcmApplyCommodityOrderPagePO.class);
        po.setSortName("baco.CREATE_TIME");
        po.setSortOrder("DESC");
        List<BcmApplyCommodityOrderPagePO> poList = bcmApplyCommodityOrderMapper.queryPendingAuditApplyCommodityOrderPageList(po, page);

        // 分页参数组装
        rspBO.setPageNo(reqBO.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRows(ObjectUtil.isNotEmpty(poList) ?
                JSONObject.parseArray(JSONObject.toJSONString(poList), BcmApplyCommodityOrderPageBO.class) : new ArrayList<>());

        // 如果结果为空直接返回
        if (ObjectUtil.isEmpty(rspBO.getRows())) {
            rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
            rspBO.setRespDesc("查询结果为空");
            return rspBO;
        }
        // 出参组装
        setRspBO(reqBO, rspBO);


        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 出参组装
     *
     * @param reqBO
     * @param rspBO
     */
    private void setRspBO(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO, BcmQueryPendingAuditApplyCommodityOrderPageListRspBO rspBO) {
        rspBO.getRows().forEach(item -> {
            // 翻译
            if (ObjectUtil.isNotEmpty(item.getApplyOrderStatus())) {
                item.setApplyOrderStatusStr(BcmPersonalApplyOrderStatusEnum.getStatusDesc(item.getApplyOrderStatus()));
            }
            if (ObjectUtil.isNotEmpty(item.getIsCustomizedFlag())) {
                item.setIsCustomizedFlagStr(BcmPersonalIsCustomizedFlagEnum.getStatusDesc(item.getIsCustomizedFlag()));
            }
            if (ObjectUtil.isNotEmpty(item.getTaskStatus())) {
                item.setTaskStatusStr(BcmPersonalCommodityConstant.TaskStatus.TaskStatusMap.get(item.getTaskStatus()));
            }
        });
    }

    /**
     * 参数校验
     *
     * @param reqBO
     */
    private void verifyParam(BcmQueryPendingAuditApplyCommodityOrderPageListReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("待审批列表查询（分页）入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getSumFlag())) {
            throw new ZTBusinessException("待审批列表查询（分页）是否查询汇总数据【sumFlag】入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getFlowType())) {
            throw new ZTBusinessException("待审批列表查询（分页）流程类型【flowType】入参为空");
        }
    }
}
