package com.tydic.bcm.personal.commodity.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.commodity.api.BcmRelGoodsTypeService;
import com.tydic.bcm.personal.commodity.bo.BcmRelGoodsTypeReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmRelGoodsTypeRspBO;
import com.tydic.bcm.personal.dao.BcmITContractTypeMapper;
import com.tydic.bcm.personal.po.BcmITContractTypePO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

import java.util.Date;

/**
 * 标题 BcmRelGoodsTypeService
 * 说明 IT合同类型管理-关联商品类型实现
 * 时间 2023/7/20 10:57
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmRelGoodsTypeServiceImpl implements BcmRelGoodsTypeService {

    @Autowired
    private BcmITContractTypeMapper bcmITContractTypeMapper;

    /**
     * 关联商品类型
     * @param reqBO
     * @return
     */
    @Override
    public BcmRelGoodsTypeRspBO relGoodsType(BcmRelGoodsTypeReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmITContractTypePO bcmITContractTypePO = getBcmITContractTypePO(reqBO);
        //关联商品类型
        bcmITContractTypeMapper.updateById(bcmITContractTypePO);
        return BcmRuUtil.success(BcmRelGoodsTypeRspBO.class);
    }


    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmITContractTypePO getBcmITContractTypePO(BcmRelGoodsTypeReqBO reqBO){
        BcmITContractTypePO bcmITContractTypePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO), BcmITContractTypePO.class);
        bcmITContractTypePO.setUpdateTime(new Date());
        bcmITContractTypePO.setUpdateUserId(reqBO.getUserId());
        bcmITContractTypePO.setUpdateUserName(reqBO.getUserName());
        return bcmITContractTypePO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmRelGoodsTypeReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(reqBO.getId() == null){
            throw new ZTBusinessException("参数IT合同类型id不能为null");
        }
        if(reqBO.getGoodsTypeId() == null){
            throw new ZTBusinessException("参数商品类型id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getGoodsTypeName())){
            throw new ZTBusinessException("参数商品类型名称不能为null");
        }
        if(reqBO.getUserId() == null){
            throw new ZTBusinessException("参数操作人id不能为null");
        }
        if(StringUtils.isEmpty(reqBO.getUserName())){
            throw new ZTBusinessException("操作人名称不能为null");
        }
    }

}
