package com.tydic.bcm.personal.commodity.impl;

import com.tydic.bcm.personal.commodity.api.BcmUpdateBatchApplyCommodityOrderService;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateBatchApplyCommodityOrderReqBO;
import com.tydic.bcm.personal.commodity.bo.BcmUpdateBatchApplyCommodityOrderRspBO;
import com.tydic.bcm.personal.dao.BcmApplyCommodityOrderMapper;
import com.tydic.bcm.personal.po.BcmQueryApplyCommodityOrderPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 标题 BcmUpdateBatchApplyCommodityOrderServiceImpl
 * 说明 批量更新上架申请单实现
 * 时间 2023/8/23 09:58
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmUpdateBatchApplyCommodityOrderServiceImpl implements BcmUpdateBatchApplyCommodityOrderService {


    /**
     * 上架申请单Mapper
     */
    @Autowired
    private BcmApplyCommodityOrderMapper bcmApplyCommodityOrderMapper;


    /**
     * 批量更新上架申请单实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmUpdateBatchApplyCommodityOrderRspBO updateBatch(BcmUpdateBatchApplyCommodityOrderReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = getBcmQueryApplyCommodityOrderPO(reqBO);
        bcmApplyCommodityOrderMapper.updateBatch(bcmQueryApplyCommodityOrderPO);
        return BcmRuUtil.success(BcmUpdateBatchApplyCommodityOrderRspBO.class);
    }

    /**
     * 参数组装
     *
     * @param reqBO
     * @return
     */
    private BcmQueryApplyCommodityOrderPO getBcmQueryApplyCommodityOrderPO(BcmUpdateBatchApplyCommodityOrderReqBO reqBO) {
        BcmQueryApplyCommodityOrderPO bcmQueryApplyCommodityOrderPO = BcmRuUtil.js(reqBO, BcmQueryApplyCommodityOrderPO.class);
        bcmQueryApplyCommodityOrderPO.setUpdateTime(new Date());
        bcmQueryApplyCommodityOrderPO.setUpdateUserId(reqBO.getUserId());
        bcmQueryApplyCommodityOrderPO.setUpdateUserName(reqBO.getUserName());
        return bcmQueryApplyCommodityOrderPO;
    }
}
