package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmCancelRelPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmAddSuggestedManagementInfoReqBO;
import com.tydic.bcm.personal.common.bo.BcmCancelRelPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmCancelRelPaymentProjectRspBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPurchasePurposeAndPaymentProjectRelMapper;
import com.tydic.bcm.personal.po.BcmPurchasePurposeAndPaymentProjectRelPO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Date;

/**
 * 类名： BcmCancelRelPaymentProjectServiceImpl
 * 说明：采购用途设置-采购用途与收支项目取消关联实现
 *
 * @author： lishiqing
 * 时间： 2023/7/25 14:28
 */
@HTServiceImpl
public class BcmCancelRelPaymentProjectServiceImpl implements BcmCancelRelPaymentProjectService {

    @Autowired
    private BcmPurchasePurposeAndPaymentProjectRelMapper bcmPurchasePurposeAndPaymentProjectRelMapper;

    @Override
    public BcmCancelRelPaymentProjectRspBO cancelRelPaymentProject(BcmCancelRelPaymentProjectReqBO reqBO) {
        BcmCancelRelPaymentProjectRspBO rspBO = new BcmCancelRelPaymentProjectRspBO();

        // 参数校验
        verifyParam(reqBO);

        // 入参组装
        BcmPurchasePurposeAndPaymentProjectRelPO setPO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        setPO.setUpdateUserId(reqBO.getUpdateUserId());
        setPO.setUpdateUserName(reqBO.getUpdateUserName());
        setPO.setUpdateOrgId(reqBO.getUpdateOrgId());
        setPO.setUpdateOrgName(reqBO.getUpdateOrgName());
        setPO.setUpdateCompanyId(reqBO.getUpdateCompanyId());
        setPO.setUpdateCompanyName(reqBO.getUpdateCompanyName());
        setPO.setUpdateTime(new Date());
        setPO.setPaymentProjectId(null);
        setPO.setPaymentProjectName(null);
        setPO.setRelStatus(BcmPersonalCommonConstant.RelStatus.UNASSOCIATED);
        BcmPurchasePurposeAndPaymentProjectRelPO wherePO = new BcmPurchasePurposeAndPaymentProjectRelPO();
        wherePO.setId(reqBO.getId());

        // 根据条件修改数据
        int i = bcmPurchasePurposeAndPaymentProjectRelMapper.updateBy(setPO, wherePO);
        if (i < 1) {
            throw new ZTBusinessException("采购用途与收支项目取消关联失败");
        }

        // 结果返回
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmCancelRelPaymentProjectReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO)) {
            throw new ZTBusinessException("采购用途与收支项目取消关联入参为空");
        }
        if (ObjectUtil.isEmpty(reqBO.getId())) {
            throw new ZTBusinessException("采购用途与收支项目取消关联入参主键ID【id】为空");
        }
    }
}
