package com.tydic.bcm.personal.common.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.common.api.BcmFullSyncPaymentProjectService;
import com.tydic.bcm.personal.common.bo.BcmFullSyncPaymentProjectReqBO;
import com.tydic.bcm.personal.common.bo.BcmFullSyncPaymentProjectRspBO;
import com.tydic.bcm.personal.common.bo.BcmPaymentProjectInfoBO;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmIdUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;


import java.util.Date;
import java.util.List;

/**
 * 标题 BcmFullSyncPaymentProjectServiceImpl
 * 说明 收支项目查询-收支项目全量同步实现
 * 时间 2023/8/3 10:42
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmFullSyncPaymentProjectServiceImpl implements BcmFullSyncPaymentProjectService {

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    /**
     * 收支项目全量同步实现
     * @param reqBO
     * @return
     */
    @Override
    public BcmFullSyncPaymentProjectRspBO fullSyncPaymentProject(BcmFullSyncPaymentProjectReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //全量同步
        fullSync(reqBO);
        return BcmRuUtil.success(BcmFullSyncPaymentProjectRspBO.class);
    }

    /**
     * 全量同步
     * @param reqBO
     */
    private void fullSync(BcmFullSyncPaymentProjectReqBO reqBO){
        List<BcmPaymentProjectInfoPO> bcmPaymentProjectInfoPOS = BcmRuUtil.jsl(reqBO.getPaymentProjectList(),BcmPaymentProjectInfoPO.class);
        Date now = new Date();
        for (BcmPaymentProjectInfoPO po:bcmPaymentProjectInfoPOS){
            if(po.getCreateTime() == null){
                po.setCreateTime(now);
            }
            if(po.getUpdateTime() == null){
                po.setUpdateTime(now);
            }
            po.setId(BcmIdUtil.nextId());
            po.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        }
        bcmPaymentProjectInfoMapper.insertBatch(bcmPaymentProjectInfoPOS);
    }
    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmFullSyncPaymentProjectReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getPaymentProjectList())){
            throw new ZTBusinessException("入参成本信息list不能为null");
        }
        for (BcmPaymentProjectInfoBO bo:reqBO.getPaymentProjectList()) {
            if(StringUtils.isEmpty(bo.getProjectCode())){
                throw new ZTBusinessException("入参项目编码不能为null");
            }
            if(StringUtils.isEmpty(bo.getProjectName())){
                throw new ZTBusinessException("入参项目名称不能为null");
            }
            if (StringUtils.isEmpty(bo.getFinancialOrgCode())){
                throw new ZTBusinessException("入参财务机构编号不能为null");
            }
            if(StringUtils.isEmpty(bo.getFinancialOrgName())){
                throw new ZTBusinessException("入参财务中心编码不能为null");

            }
            if(bo.getStatus() == null){
                throw new ZTBusinessException("入参状态不能为null");
            }
        }
    }
}
