package com.tydic.bcm.personal.common.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryFinanceMatterApplyPageListService;
import com.tydic.bcm.personal.common.bo.BcmFinanceMatterApplyBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFinanceMatterApplyPageListReqBO;
import com.tydic.bcm.personal.common.bo.BcmQueryFinanceMatterApplyPageListRspBO;
import com.tydic.bcm.personal.dao.BcmBudgetProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmFinanceMatterApplyMapper;
import com.tydic.bcm.personal.po.BcmBudgetProjectInfoPO;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyExtendPO;
import com.tydic.bcm.personal.po.BcmFinanceMatterApplyPO;
import com.tydic.bcm.personal.utils.BcmCommonBeanUtil;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.bcm.personal.utils.ParamValidateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.ohaotian.HTServiceImpl;

import java.util.List;

/**
 * @author : civism
 * @version 1.0
 * @date 2023/8/16 15:52
 * 用于财务事项申请/财务事项所对应的预算项目列表查询
 */
@HTServiceImpl
@RequiredArgsConstructor
public class BcmQueryFinanceMatterApplyPageListServiceImpl implements BcmQueryFinanceMatterApplyPageListService {

    private final BcmFinanceMatterApplyMapper financeMatterApplyMapper;

    private final BcmBudgetProjectInfoMapper budgetProjectInfoMapper;


    @Override
    public BcmQueryFinanceMatterApplyPageListRspBO queryFinanceMatterApplyPageList(BcmQueryFinanceMatterApplyPageListReqBO reqBO) {
        ParamValidateUtils.validate(reqBO);
        BcmFinanceMatterApplyExtendPO bcmFinanceMatterApplyExtendPO = BeanUtil.copyProperties(reqBO, BcmFinanceMatterApplyExtendPO.class);
        Page<BcmFinanceMatterApplyPO> page = new Page<>(reqBO.getPageNo(), reqBO.getPageSize());
        List<BcmFinanceMatterApplyPO> bcmFinanceMatterApplyPOS = financeMatterApplyMapper.queryFinanceMatterApplyPageList(bcmFinanceMatterApplyExtendPO, page);
        BcmQueryFinanceMatterApplyPageListRspBO rspBO = BcmRuUtil.success(BcmQueryFinanceMatterApplyPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        List<BcmFinanceMatterApplyBO> bcmFinanceMatterApplyBOS = BcmCommonBeanUtil.listCopyProperties(bcmFinanceMatterApplyPOS, BcmFinanceMatterApplyBO.class);
        if (CollectionUtil.isNotEmpty(bcmFinanceMatterApplyBOS)) {
            bcmFinanceMatterApplyBOS.forEach(bcmFinanceMatterApplyBO -> {
                BcmBudgetProjectInfoPO budgetProjectInfo = budgetProjectInfoMapper.getBudgetProjectInfo(bcmFinanceMatterApplyBO.getBudgetProjectCode(), bcmFinanceMatterApplyBO.getFinanceOrgCode());
                if (budgetProjectInfo != null) {
                    bcmFinanceMatterApplyBO.setBudgetProjectId(budgetProjectInfo.getProjectId());
                }
            });
        }
        rspBO.setRows(bcmFinanceMatterApplyBOS);
        return rspBO;
    }
}
