package com.tydic.bcm.personal.common.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.common.api.BcmQueryPaymentProjectPageListService;
import com.tydic.bcm.personal.common.bo.*;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmPaymentProjectInfoMapper;
import com.tydic.bcm.personal.po.BcmPaymentProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryPaymentProjectInfoPO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 标题 BcmQueryPaymentProjectPageListServiceImpl
 * 说明 收支项目查询-收支项目列表查询(分页)实现
 * 时间 2023/7/21 14:25
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmQueryPaymentProjectPageListServiceImpl implements BcmQueryPaymentProjectPageListService {

    @Autowired
    private BcmPaymentProjectInfoMapper bcmPaymentProjectInfoMapper;

    /**
     * 收支项目列表查询(分页)
     * @param reqBO
     * @return
     */
    @Override
    public BcmQueryPaymentProjectPageListRspBO queryPaymentProjectPageList(BcmQueryPaymentProjectPageListReqBO reqBO) {
        //参数校验
        verifyParam(reqBO);
        //参数组装
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = getBcmQueryPaymentProjectInfoPO(reqBO);
        Page<BcmPaymentProjectInfoPO> page = new Page<>(reqBO.getPageNo(),reqBO.getPageSize());
        //收支项目列表查询
        List<BcmPaymentProjectInfoPO> list = bcmPaymentProjectInfoMapper.getListPage(bcmQueryPaymentProjectInfoPO, page);
        return setRspBO(list,page);
    }

    /**
     * 出参组装
     * @param list
     * @param page
     * @return
     */
    private BcmQueryPaymentProjectPageListRspBO setRspBO(List<BcmPaymentProjectInfoPO> list, Page<BcmPaymentProjectInfoPO> page){
        BcmQueryPaymentProjectPageListRspBO rspBO = BcmRuUtil.success(BcmQueryPaymentProjectPageListRspBO.class);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(BcmRuUtil.jsl(list,BcmPaymentProjectInfoBO.class));
        if(!CollectionUtils.isEmpty(rspBO.getRows())){
            for (BcmPaymentProjectInfoBO bo: rspBO.getRows()){
                if(BcmPersonalCommonConstant.Status.DISABLE.equals(bo.getStatus())){
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.DISABLE_STR);
                } else if (BcmPersonalCommonConstant.Status.ENABLE.equals(bo.getStatus())) {
                    bo.setStatusStr(BcmPersonalCommonConstant.Status.ENABLE_STR);
                }
            }
        }
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        return rspBO;
    }
    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryPaymentProjectInfoPO getBcmQueryPaymentProjectInfoPO(BcmQueryPaymentProjectPageListReqBO reqBO){
        BcmQueryPaymentProjectInfoPO bcmQueryPaymentProjectInfoPO = JSONObject.parseObject(JSONObject.toJSONString(reqBO),BcmQueryPaymentProjectInfoPO.class);
        bcmQueryPaymentProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        bcmQueryPaymentProjectInfoPO.setOrderBy("UPDATE_TIME DESC");
        return bcmQueryPaymentProjectInfoPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmQueryPaymentProjectPageListReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
    }
}
