package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.BcmTbBudgetsubFmisPO;
import com.tydic.bcm.personal.po.BcmTbBudgetsubFmisUpdatePO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： BcmTbBudgetsubFmisMapper
 * 说明：NC基础数据临时表：预算科目--Mapper
 *
 * @author： lishiqing
 * 时间： 2023/8/15 14:22
 */
@Mapper
@Repository
public interface BcmTbBudgetsubFmisMapper {

    /**
     * 根据条件收支项目临时表分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmTbBudgetsubFmisPO> getPageList(BcmTbBudgetsubFmisPO po, Page<BcmTbBudgetsubFmisPO> page);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmTbBudgetsubFmisUpdatePO set, @Param("where") BcmTbBudgetsubFmisUpdatePO where);
}
