package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 类名： BcmUserInfoIpspMapper
 * 说明：用户临时表--Mapper
 *
 * @author： lishiqing
 * 时间： 2023/8/16 12:10
 */
@Mapper
@Repository
public interface BcmUserInfoIpspMapper {
    /**
     * 根据条件收支项目临时表分页查询列表数据
     * @param po 参数对象
     * @param page 分页参数
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmUserInfoIpspPO> getPageList(BcmUserInfoIpspQueryPO po, Page<BcmUserInfoIpspPO> page);

    /**
     * 根据条件更新数据
     *
     * @param set set新值
     * @param where where条件（旧值）
     * @return int 影响数量
     */
    int updateBy(@Param("set") BcmUserInfoIpspUpdatePO set, @Param("where")BcmUserInfoIpspUpdatePO where);

    /**
     * 根据条件收支项目临时表查询列表数据
     * @param po 参数对象
     * @return List<BcmTbBudgetsubFmisPO> 结果对象
     */
    List<BcmUserInfoIpspPO> getList(BcmUserInfoIpspQueryPO po);
}
