package com.tydic.bcm.personal.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.po.TChnipmpSupplierExtendPO;
import com.tydic.bcm.personal.po.TChnipmpSupplierPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;

/**
 * (IPMP)供应商表;(t_chnipmp_supplier)表数据库访问层
 * @author : civism
 * @date : 2023-8-17
 */
@Mapper
public interface TChnipmpSupplierMapper{
    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    TChnipmpSupplierPO queryById(Long id);
    /**
     * 分页查询指定行数据
     *
     * @param tChnipmpSupplier 查询条件
     * @param page 分页对象
     * @return 对象列表
     */
    List<TChnipmpSupplierPO> queryAllByLimit(TChnipmpSupplierExtendPO tChnipmpSupplier, Page<TChnipmpSupplierPO> page);


    /**
     * 查询最近
     * @param companyIdList
     * @param lastSyncDate
     * @return
     */
    List<TChnipmpSupplierPO> queryLastByCompanyId(List<String> companyIdList, Date lastSyncDate);
    /**
     * 统计总行数
     *
     * @param tChnipmpSupplier 查询条件
     * @return 总行数
     */
    long count(TChnipmpSupplierPO tChnipmpSupplier);
    /**
     * 新增数据
     *
     * @param tChnipmpSupplier 实例对象
     * @return 影响行数
     */
    int insert(TChnipmpSupplierPO tChnipmpSupplier);
    /**
     * 批量新增数据
     *
     * @param entities List<TChnipmpSupplier> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<TChnipmpSupplierPO> entities);
    /**
     * 批量新增或按主键更新数据
     *
     * @param entities List<TChnipmpSupplier> 实例对象列表
     * @return 影响行数
     */
    int insertOrUpdateBatch(@Param("entities") List<TChnipmpSupplierPO> entities);
    /**
     * 更新数据
     *
     * @param tChnipmpSupplier 实例对象
     * @return 影响行数
     */
    int update(TChnipmpSupplierPO tChnipmpSupplier);
    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
}