package com.tydic.bcm.personal.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * (IPMP)供应商账号;智采平台基础数据临时表：供应商账号
 *
 * @author : civism
 * @date : 2023-8-17
 */
@Data
public class TChnipmpSupplierUserPO implements Serializable {
    private static final long serialVersionUID = -8168273630972137913L;
    /**
     * ID
     */
    private Long id;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 所属供应商id
     */
    private String supplierId;
    /**
     * 用户名
     */
    private String supplierAccount;
    /**
     * 姓名
     */
    private String userName;
    /**
     * 手机号
     */
    private String linkMobile;
    /**
     * 固定电话
     */
    private String linkTel;
    /**
     * 邮箱
     */
    private String linkEmail;
    /**
     * 用户状态;用户状态：00正常；01分配；02暂停；03删除
     */
    private String status;
    /**
     * 创建时间
     */
    private Date recCrtTs;
    /**
     * 更新时间
     */
    private Date recUpdTs;
    /**
     * 推送时间
     */
    private Date pushTime;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 处理结果;处理结果:
     * SUCCESS:同步成功
     * FAIL:同步失败
     * SKIP:无需同步
     * PENDING:待同步
     */
    private String dealResult;


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        TChnipmpSupplierUserPO that = (TChnipmpSupplierUserPO) o;
        return Objects.equals(userId, that.userId) && Objects.equals(supplierId, that.supplierId) && Objects.equals(supplierAccount, that.supplierAccount) && Objects.equals(userName, that.userName) && Objects.equals(linkMobile, that.linkMobile) && Objects.equals(linkTel, that.linkTel) && Objects.equals(linkEmail, that.linkEmail) && Objects.equals(status, that.status) && Objects.equals(recCrtTs, that.recCrtTs) && Objects.equals(recUpdTs, that.recUpdTs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(userId, supplierId, supplierAccount, userName, linkMobile, linkTel, linkEmail, status, recCrtTs, recUpdTs);
    }
}