package com.tydic.bcm.personal.settle.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.bcm.personal.constants.BcmPersonalSettleConstant;
import com.tydic.bcm.personal.dao.BcmBondDeductInfoMapper;
import com.tydic.bcm.personal.po.BcmBondDeductInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBondDeductInfoPO;
import com.tydic.bcm.personal.settle.api.BcmDeleteBatchBondDeductService;
import com.tydic.bcm.personal.settle.bo.BcmDeleteBatchBondDeductReqBO;
import com.tydic.bcm.personal.settle.bo.BcmDeleteBatchBondDeductRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;

/**
 * 标题 BcmDeleteBatchBondDeductServiceImpl
 * 说明 保证金管理-保证金扣除申请单删除（批量）实现
 * 时间 2023/7/25 14:38
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmDeleteBatchBondDeductServiceImpl implements BcmDeleteBatchBondDeductService {

   @Autowired
   private BcmBondDeductInfoMapper bcmBondDeductInfoMapper;

    @Override
    public BcmDeleteBatchBondDeductRspBO deleteBatchBondDeduct(BcmDeleteBatchBondDeductReqBO reqBO) {
        //参数验证
        verifyParam(reqBO);
        //是否可删除检测
        check(reqBO);
        //参数组装
        BcmQueryBondDeductInfoPO queryPO = getBcmBondDeductInfoPO(reqBO);
        bcmBondDeductInfoMapper.updateBatchById(queryPO);
        return BcmRuUtil.success(BcmDeleteBatchBondDeductRspBO.class);
    }


    /**
     * 是否可删除检测
     * @param reqBO
     */
    private void check(BcmDeleteBatchBondDeductReqBO reqBO){
        BcmQueryBondDeductInfoPO bcmQueryBondDeductInfoPO = new BcmQueryBondDeductInfoPO();
        bcmQueryBondDeductInfoPO.setIds(reqBO.getIds());
        List<BcmBondDeductInfoPO> list = bcmBondDeductInfoMapper.getList(bcmQueryBondDeductInfoPO);
        for (BcmBondDeductInfoPO po:list){
            if(BcmPersonalSettleConstant.BondDeductStatus.CONFIRMED.equals(po.getDocStatus())){
                throw new ZTBusinessException("存在已确认数据，删除失败");
            }
        }
    }
    /**
     * 参数组装
     * @param reqBO
     * @return
     */
    private BcmQueryBondDeductInfoPO getBcmBondDeductInfoPO(BcmDeleteBatchBondDeductReqBO reqBO) {
        BcmQueryBondDeductInfoPO queryPO = BcmRuUtil.js(reqBO, BcmQueryBondDeductInfoPO.class);
        queryPO.setUpdateTime(new Date());
        queryPO.setUpdateUserName(reqBO.getUserName());
        queryPO.setUpdateUserId(reqBO.getUserId());
        queryPO.setDelFlag(BcmPersonalSettleConstant.DelFlag.YES);
        return queryPO;
    }

    /**
     * 参数校验
     * @param reqBO
     */
    private void verifyParam(BcmDeleteBatchBondDeductReqBO reqBO){
        if(reqBO == null){
            throw new ZTBusinessException("入参对象不能为null");
        }
        if(CollectionUtils.isEmpty(reqBO.getIds())){
            throw new ZTBusinessException("入参数据id集合不能为null");
        }
    }
}
