package com.tydic.bcm.personal.task.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.bcm.personal.constants.BcmDealResultEnum;
import com.tydic.bcm.personal.constants.BcmPersonalCommonConstant;
import com.tydic.bcm.personal.dao.BcmBasicProjectInfoMapper;
import com.tydic.bcm.personal.dao.BcmTChnipmpProjectMapper;
import com.tydic.bcm.personal.po.BcmBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryBasicProjectInfoPO;
import com.tydic.bcm.personal.po.BcmQueryTChnipmpProjectPO;
import com.tydic.bcm.personal.po.BcmTChnipmpProjectPO;
import com.tydic.bcm.personal.task.api.BcmBasicProjectSyncTaskService;
import com.tydic.bcm.personal.task.bo.BcmBasicProjectSyncTaskReqBO;
import com.tydic.bcm.personal.task.bo.BcmBasicProjectSyncTaskRspBO;
import com.tydic.bcm.personal.utils.BcmRuUtil;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题 BcmBasicProjectSyncTaskServiceImpl
 * 说明 项目基本信息同步对比服务实现
 * 时间 2023/8/17 15:05
 *
 * @author 唐富强
 */
@HTServiceImpl
public class BcmBasicProjectSyncTaskServiceImpl implements BcmBasicProjectSyncTaskService {

    @Autowired
    private BcmTChnipmpProjectMapper bcmTChnipmpProjectMapper;

    @Autowired
    private BcmBasicProjectInfoMapper bcmBasicProjectInfoMapper;

    @Value("${dealSize:100}")
    private Integer dealSize;


    /**
     * 项目基本信息同步对比服务实现
     *
     * @param reqBO
     * @return
     */
    @Override
    public BcmBasicProjectSyncTaskRspBO syncBasicProject(BcmBasicProjectSyncTaskReqBO reqBO) {
        sync();
        return BcmRuUtil.success(BcmBasicProjectSyncTaskRspBO.class);
    }

    /**
     * 数据同步对比
     */
    private void sync() {
        Page<BcmTChnipmpProjectPO> page = getChnipmpProject();
        List<BcmTChnipmpProjectPO> syncList = page.getResult();
        if (CollectionUtils.isEmpty(syncList)) {
            return;
        }
        Map<String, BcmBasicProjectInfoPO> thanMap = getBasicProject(syncList);
        List<Long> successIdList = new ArrayList<>(syncList.size());
        if (CollectionUtils.isEmpty(thanMap)) {
            addBasicProject(syncList);
            successIdList = syncList.stream().map(BcmTChnipmpProjectPO::getId).collect(Collectors.toList());
        } else {
            List<BcmTChnipmpProjectPO> addList = new ArrayList<>(syncList.size());
            List<BcmBasicProjectInfoPO> updateList = new ArrayList<>(syncList.size());
            List<Long> skipIdList = new ArrayList<>(syncList.size());
            for (BcmTChnipmpProjectPO po : syncList) {
                BcmBasicProjectInfoPO basicProjectInfoPO = thanMap.get(po.getProjectNo());
                if (basicProjectInfoPO == null) {
                    addList.add(po);
                    successIdList.add(po.getId());
                } else {
                    if (!basicProjectInfoPO.getProjectName().equals(po.getProjectNane())
                            || !basicProjectInfoPO.getOneInstitution().equals(po.getOneInstitution())
                            || !basicProjectInfoPO.getTwoInstitution().equals(po.getTwoInstitution())
                            || !basicProjectInfoPO.getThreeInstitution().equals(po.getThreeInstitution())
                            || !basicProjectInfoPO.getFourInstitution().equals(po.getFourInstitution())
                            || basicProjectInfoPO.getBudgetMoney().compareTo(new BigDecimal(po.getProjectBudget())) != 0
                    ) {
                        BcmBasicProjectInfoPO update = setBcmBasicProject(po);
                        update.setId(basicProjectInfoPO.getId());
                        updateList.add(update);
                        successIdList.add(po.getId());
                    } else {
                        skipIdList.add(po.getId());
                    }
                }
            }
            //新增项目基本信息
            if (!CollectionUtils.isEmpty(addList)) {
                addBasicProject(addList);
            }
            //修改项目基本信息
            if (!CollectionUtils.isEmpty(updateList)) {
                bcmBasicProjectInfoMapper.updateBatch(updateList);
            }
            if (!CollectionUtils.isEmpty(skipIdList)) {
                updateChnipmpProject(skipIdList, BcmDealResultEnum.SKIP.getDealResult());
            }
        }
        if (!CollectionUtils.isEmpty(successIdList)) {
            updateChnipmpProject(successIdList, BcmDealResultEnum.SUCCESS.getDealResult());
        }
        if (page.getTotalPages() > 1) {
            sync();
        }
    }

    /**
     * 更新项目临时表信息
     *
     * @param idList
     * @param dealResult
     */
    private void updateChnipmpProject(List<Long> idList, String dealResult) {
        BcmQueryTChnipmpProjectPO bcmQueryTChnipmpProjectPO = new BcmQueryTChnipmpProjectPO();
        bcmQueryTChnipmpProjectPO.setIdList(idList);
        bcmQueryTChnipmpProjectPO.setDealResult(dealResult);
        bcmQueryTChnipmpProjectPO.setDealTime(new Date());
        bcmTChnipmpProjectMapper.updateBatch(bcmQueryTChnipmpProjectPO);
    }

    /**
     * 新增项目基本信息
     */
    private void addBasicProject(List<BcmTChnipmpProjectPO> syncList) {
        List<BcmBasicProjectInfoPO> bcmBasicProjectInfoPOS = new ArrayList<>();
        for (BcmTChnipmpProjectPO po : syncList) {
            BcmBasicProjectInfoPO basicProjectInfoPO = setBcmBasicProject(po);
            bcmBasicProjectInfoPOS.add(basicProjectInfoPO);
        }
        bcmBasicProjectInfoMapper.insertBatch(bcmBasicProjectInfoPOS);
    }

    /**
     * 设置项目基本信息PO
     *
     * @param po
     * @return
     */
    private BcmBasicProjectInfoPO setBcmBasicProject(BcmTChnipmpProjectPO po) {
        BcmBasicProjectInfoPO bcmBasicProjectInfoPO = setBasicProjectOrg(po);
        bcmBasicProjectInfoPO.setId(po.getId());
        bcmBasicProjectInfoPO.setProjectName(po.getProjectNane());
        bcmBasicProjectInfoPO.setProjectCode(po.getProjectNo());
        bcmBasicProjectInfoPO.setProjectId(po.getProjectId());
        bcmBasicProjectInfoPO.setBudgetMoney(new BigDecimal(po.getProjectBudget()));
        bcmBasicProjectInfoPO.setProOrgName(getProOrgName(po));
        bcmBasicProjectInfoPO.setOneInstitution(po.getOneInstitution());
        bcmBasicProjectInfoPO.setOneOrgName(po.getOneOrgName());
        bcmBasicProjectInfoPO.setCreateTime(po.getCreateDate());
        bcmBasicProjectInfoPO.setCreateUserName(po.getExecuUserName());
        bcmBasicProjectInfoPO.setUpdateTime(po.getUpdateTime());
        bcmBasicProjectInfoPO.setStatus(BcmPersonalCommonConstant.Status.ENABLE);
        bcmBasicProjectInfoPO.setDelFlag(BcmPersonalCommonConstant.DelFlag.NO);
        return bcmBasicProjectInfoPO;
    }

    /**
     * 项目基本信息组织设置
     *
     * @param po
     * @return
     */
    private BcmBasicProjectInfoPO setBasicProjectOrg(BcmTChnipmpProjectPO po) {
        BcmBasicProjectInfoPO bcmBasicProjectInfoPO = new BcmBasicProjectInfoPO();
        bcmBasicProjectInfoPO.setOneInstitution(po.getOneInstitution());
        bcmBasicProjectInfoPO.setOneOrgName(po.getOneOrgName());
        bcmBasicProjectInfoPO.setStatus(BcmPersonalCommonConstant.Status.ENABLE);
        if (StringUtils.isNotBlank(po.getTwoInstitution())) {
            bcmBasicProjectInfoPO.setTwoInstitution(po.getTwoInstitution());
            bcmBasicProjectInfoPO.setTwoOrgName(po.getTwoOrgName());
            if (StringUtils.isNotBlank(po.getThreeInstitution())) {
                bcmBasicProjectInfoPO.setThreeInstitution(po.getThreeInstitution());
                bcmBasicProjectInfoPO.setThreeOrgName(po.getThreeOrgName());
                if (StringUtils.isNotBlank(po.getFourInstitution())) {
                    bcmBasicProjectInfoPO.setFourInstitution(po.getFourInstitution());
                    bcmBasicProjectInfoPO.setFourOrgName(po.getFourOrgName());
                } else {
                    bcmBasicProjectInfoPO.setFourInstitution(po.getThreeInstitution());
                    bcmBasicProjectInfoPO.setFourOrgName(po.getThreeOrgName());
                }
            } else {
                bcmBasicProjectInfoPO.setThreeInstitution(po.getTwoInstitution());
                bcmBasicProjectInfoPO.setThreeOrgName(po.getTwoOrgName());
                bcmBasicProjectInfoPO.setFourInstitution(po.getTwoInstitution());
                bcmBasicProjectInfoPO.setFourOrgName(po.getTwoOrgName());
            }
        } else {
            bcmBasicProjectInfoPO.setTwoInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setTwoOrgName(po.getOneOrgName());
            bcmBasicProjectInfoPO.setThreeInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setThreeOrgName(po.getOneOrgName());
            bcmBasicProjectInfoPO.setFourInstitution(po.getOneInstitution());
            bcmBasicProjectInfoPO.setFourOrgName(po.getOneOrgName());
        }
        return bcmBasicProjectInfoPO;
    }

    /**
     * 组装采购组织名称
     *
     * @param po
     * @return
     */
    private String getProOrgName(BcmTChnipmpProjectPO po) {
        StringBuilder builder = new StringBuilder();
        builder.append(po.getOneOrgName());
        if (StringUtils.isNotBlank(po.getTwoInstitution()) && !po.getOneInstitution().equals(po.getTwoInstitution())) {
            builder.append(BcmPersonalCommonConstant.Str.CONNECTOR + po.getTwoOrgName());
            if (StringUtils.isNotBlank(po.getThreeInstitution()) && !po.getTwoInstitution().equals(po.getThreeInstitution())) {
                builder.append(BcmPersonalCommonConstant.Str.CONNECTOR + po.getThreeOrgName());
                if (StringUtils.isNotBlank(po.getFourInstitution()) && !po.getThreeInstitution().equals(po.getFourInstitution())) {
                    builder.append(BcmPersonalCommonConstant.Str.CONNECTOR + po.getFourOrgName());
                }
            }
        }
        return builder.toString();
    }

    /**
     * 对比项目基本信息获取
     *
     * @return
     */
    private Map<String, BcmBasicProjectInfoPO> getBasicProject(List<BcmTChnipmpProjectPO> syncList) {
        BcmQueryBasicProjectInfoPO bcmQueryBasicProjectInfoPO = new BcmQueryBasicProjectInfoPO();
        bcmQueryBasicProjectInfoPO.setProjectCodeList(syncList.stream().map(BcmTChnipmpProjectPO::getProjectNo).collect(Collectors.toList()));
        List<BcmBasicProjectInfoPO> list = bcmBasicProjectInfoMapper.getList(bcmQueryBasicProjectInfoPO);
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.stream().collect(Collectors.toMap(BcmBasicProjectInfoPO::getProjectCode, o -> o, (k1, k2) -> k2));
    }

    /**
     * 待同步数据获取
     *
     * @return
     */
    private Page<BcmTChnipmpProjectPO> getChnipmpProject() {
        BcmTChnipmpProjectPO bcmTChnipmpProjectPO = new BcmTChnipmpProjectPO();
        bcmTChnipmpProjectPO.setDealResult(BcmDealResultEnum.PENDING.getDealResult());
        Page<BcmTChnipmpProjectPO> page = new Page<>(1, dealSize);
        List<BcmTChnipmpProjectPO> pageList = bcmTChnipmpProjectMapper.getPageList(bcmTChnipmpProjectPO, page);
        page.setResult(pageList);
        return page;
    }
}
